/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.FileSystemItemChangeImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class AuditChangeFinder
implements FileSystemChangeFinder {
    private static final long serialVersionUID = 1963018967324857522L;
    private static final Logger log = LogManager.getLogger(AuditChangeFinder.class);
    protected Map<String, String> parameters = new HashMap<String, String>();

    @Override
    public void handleParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    @Override
    public List<FileSystemItemChange> getFileSystemChanges(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, int limit) throws TooManyChangesException {
        String principalName = session.getPrincipal().getName();
        ArrayList<FileSystemItemChange> changes = new ArrayList<FileSystemItemChange>();
        List<LogEntry> entries = this.queryAuditEntries(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, limit);
        for (LogEntry entry : entries) {
            if (!"NuxeoDrive".equals(entry.getCategory())) continue;
            log.debug("Detected sync root change for user '{}' in audit log: invalidating the root cache and refetching the changes.", (Object)principalName);
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
            driveManager.invalidateSynchronizationRootsCache(principalName);
            driveManager.invalidateCollectionSyncRootMemberCache(principalName);
            Map<String, SynchronizationRoots> synchronizationRoots = driveManager.getSynchronizationRoots(session.getPrincipal());
            SynchronizationRoots updatedActiveRoots = synchronizationRoots.get(session.getRepositoryName());
            Set<String> updatedCollectionSyncRootMemberIds = driveManager.getCollectionSyncRootMemberIds(session.getPrincipal()).get(session.getRepositoryName());
            entries = this.queryAuditEntries(session, updatedActiveRoots, updatedCollectionSyncRootMemberIds, lowerBound, upperBound, limit);
            break;
        }
        if (entries.size() >= limit) {
            throw new TooManyChangesException("Too many changes found in the audit logs.");
        }
        for (LogEntry entry : entries) {
            log.debug("Handling log entry {}", (Object)entry);
            FileSystemItemChange change = null;
            IdRef docRef = new IdRef(entry.getDocUUID());
            ExtendedInfo fsIdInfo = (ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemId");
            if (fsIdInfo != null) {
                log.debug("Found extended info in audit log entry: document has been deleted, moved, is an unregistered synchronization root or its security has been updated, we just know the FileSystemItem id and name.");
                boolean isChangeSet = false;
                if (!"deleted".equals(entry.getEventId()) && session.exists((DocumentRef)docRef) && (change = this.getFileSystemItemChange(session, (DocumentRef)docRef, entry, (String)fsIdInfo.getValue(String.class))) != null) {
                    if ("moved".equals(entry.getEventId())) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = () -> ((LogEntry)entry).getDocPath();
                        supplierArray[1] = () -> AuditChangeFinder.lambda$getFileSystemChanges$0((DocumentRef)docRef);
                        log.debug("Document {} ({}) has been moved to another synchronzation root, not adding entry to the change summary.", supplierArray);
                        continue;
                    }
                    isChangeSet = true;
                }
                if (!isChangeSet) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((LogEntry)entry).getDocPath();
                    supplierArray[1] = () -> AuditChangeFinder.lambda$getFileSystemChanges$1((DocumentRef)docRef);
                    log.debug("Document {} ({}) doesn't exist or is not adaptable as a FileSystemItem, only providing the FileSystemItem id and name to the FileSystemItemChange entry.", supplierArray);
                    String fsId = (String)fsIdInfo.getValue(String.class);
                    String eventId = "moved".equals(entry.getEventId()) ? "deleted" : entry.getEventId();
                    change = new FileSystemItemChangeImpl(eventId, entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsId, null);
                }
                log.debug("Adding FileSystemItemChange entry to the change summary: {}", change);
                changes.add(change);
                continue;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((LogEntry)entry).getDocPath();
            supplierArray[1] = () -> AuditChangeFinder.lambda$getFileSystemChanges$2((DocumentRef)docRef);
            log.debug("No extended info found in audit log entry {} ({}): this is not a deleted document, a moved document, an unregistered synchronization root nor a security update denying access to the current user.", supplierArray);
            if (!session.exists((DocumentRef)docRef)) {
                Supplier[] supplierArray2 = new Supplier[2];
                supplierArray2[0] = () -> ((LogEntry)entry).getDocPath();
                supplierArray2[1] = () -> AuditChangeFinder.lambda$getFileSystemChanges$3((DocumentRef)docRef);
                log.debug("Document {} ({}) doesn't exist, not adding entry to the change summary.", supplierArray2);
                continue;
            }
            change = this.getFileSystemItemChange(session, (DocumentRef)docRef, entry, null);
            if (change == null) {
                Supplier[] supplierArray3 = new Supplier[2];
                supplierArray3[0] = () -> ((LogEntry)entry).getDocPath();
                supplierArray3[1] = () -> AuditChangeFinder.lambda$getFileSystemChanges$4((DocumentRef)docRef);
                log.debug("Document {} ({}) is not adaptable as a FileSystemItem, not adding any entry to the change summary.", supplierArray3);
                continue;
            }
            log.debug("Adding FileSystemItemChange entry to the change summary: {}", (Object)change);
            changes.add(change);
        }
        return changes;
    }

    @Override
    public long getUpperBound() {
        AuditReader auditService = (AuditReader)Framework.getService(AuditReader.class);
        String auditQuery = "from LogEntry log order by log.id desc";
        log.debug("Querying audit log for greatest id: {}", (Object)auditQuery);
        List entries = auditService.nativeQuery(auditQuery, 1, 1);
        if (entries.isEmpty()) {
            log.debug("Found no audit log entries, returning -1");
            return -1L;
        }
        return ((LogEntry)entries.get(0)).getId();
    }

    @Override
    public long getUpperBound(Set<String> repositoryNames) {
        long clusteringDelay = this.getClusteringDelay(repositoryNames);
        AuditReader auditService = (AuditReader)Framework.getService(AuditReader.class);
        HashMap<String, Date> params = new HashMap<String, Date>();
        StringBuilder auditQuerySb = new StringBuilder("from LogEntry log");
        if (clusteringDelay > -1L) {
            long lastClusteringInvalidationDate = System.currentTimeMillis() - 2L * clusteringDelay;
            params.put("lastClusteringInvalidationDate", new Date(lastClusteringInvalidationDate));
            auditQuerySb.append(" where log.logDate < :lastClusteringInvalidationDate");
        }
        auditQuerySb.append(" order by log.id desc");
        String auditQuery = auditQuerySb.toString();
        log.debug("Querying audit log for greatest id: {} with params: {}", (Object)auditQuery, params);
        List entries = auditService.nativeQuery(auditQuery, params, 1, 1);
        if (entries.isEmpty()) {
            List allEntries;
            if (clusteringDelay > -1L && !(allEntries = auditService.nativeQuery("from LogEntry", 1, 1)).isEmpty()) {
                log.debug("Found no audit log entries matching the criterias but some exist, returning 0");
                return 0L;
            }
            log.debug("Found no audit log entries, returning -1");
            return -1L;
        }
        return ((LogEntry)entries.get(0)).getId();
    }

    protected long getClusteringDelay(Set<String> repositoryNames) {
        long clusteringDelay = -1L;
        SQLRepositoryService repositoryService = (SQLRepositoryService)Framework.getService(SQLRepositoryService.class);
        for (String repositoryName : repositoryNames) {
            RepositoryDescriptor repositoryDescriptor = repositoryService.getRepositoryDescriptor(repositoryName);
            if (repositoryDescriptor == null || !repositoryDescriptor.getClusteringEnabled()) continue;
            clusteringDelay = Math.max(clusteringDelay, repositoryDescriptor.getClusteringDelay());
        }
        return clusteringDelay;
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, int limit) {
        AuditReader auditService = (AuditReader)Framework.getService(AuditReader.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("repositoryId", session.getRepositoryName());
        StringBuilder auditQuerySb = new StringBuilder("from LogEntry log where ");
        auditQuerySb.append("log.repositoryId = :repositoryId");
        auditQuerySb.append(" and ");
        auditQuerySb.append("(");
        if (!activeRoots.getPaths().isEmpty()) {
            auditQuerySb.append("(");
            auditQuerySb.append("log.category = 'eventDocumentCategory'");
            auditQuerySb.append(" and (log.eventId = 'documentCreated' or log.eventId = 'documentModified' or log.eventId = 'documentMoved' or log.eventId = 'documentCreatedByCopy' or log.eventId = 'documentRestored' or log.eventId = 'addedToCollection' or log.eventId = 'documentProxyPublished' or log.eventId = 'documentLocked' or log.eventId = 'documentUnlocked' or log.eventId = 'documentUntrashed')");
            auditQuerySb.append(" or ");
            auditQuerySb.append("log.category = 'eventLifeCycleCategory'");
            auditQuerySb.append(" and log.eventId = 'lifecycle_transition_event' and log.docLifeCycle != 'deleted' ");
            auditQuerySb.append(") and (");
            auditQuerySb.append("(");
            auditQuerySb.append(this.getCurrentRootFilteringClause(activeRoots.getPaths(), params));
            auditQuerySb.append(")");
            if (collectionSyncRootMemberIds != null && !collectionSyncRootMemberIds.isEmpty()) {
                auditQuerySb.append(" or (");
                auditQuerySb.append(this.getCollectionSyncRootFilteringClause(collectionSyncRootMemberIds, params));
                auditQuerySb.append(")");
            }
            auditQuerySb.append(") or ");
        }
        auditQuerySb.append("(");
        auditQuerySb.append("log.category = '");
        auditQuerySb.append("NuxeoDrive");
        auditQuerySb.append("' and log.eventId != 'rootUnregistered'");
        auditQuerySb.append(")");
        auditQuerySb.append(") and (");
        auditQuerySb.append(this.getJPARangeClause(lowerBound, upperBound, params));
        auditQuerySb.append(") order by log.repositoryId asc, log.eventDate desc");
        String auditQuery = auditQuerySb.toString();
        log.debug("Querying audit log for changes: {} with params: {}", (Object)auditQuery, params);
        List entries = auditService.nativeQuery(auditQuery, params, 1, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            log.debug("Change detected: {}", (Object)entry);
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected String getCurrentRootFilteringClause(Set<String> rootPaths, Map<String, Object> params) {
        StringBuilder rootPathClause = new StringBuilder();
        int rootPathCount = 0;
        for (String rootPath : rootPaths) {
            String rootPathParam = "rootPath" + ++rootPathCount;
            if (rootPathClause.length() > 0) {
                rootPathClause.append(" or ");
            }
            rootPathClause.append(String.format("log.docPath like :%s", rootPathParam));
            params.put(rootPathParam, rootPath + '%');
        }
        return rootPathClause.toString();
    }

    protected String getCollectionSyncRootFilteringClause(Set<String> collectionSyncRootMemberIds, Map<String, Object> params) {
        String paramName = "collectionMemberIds";
        params.put(paramName, collectionSyncRootMemberIds);
        return String.format("log.docUUID in (:%s)", paramName);
    }

    protected String getJPARangeClause(long lowerBound, long upperBound, Map<String, Object> params) {
        params.put("lowerBound", lowerBound);
        params.put("upperBound", upperBound);
        return "log.id > :lowerBound and log.id <= :upperBound";
    }

    protected FileSystemItemChange getFileSystemItemChange(CoreSession session, DocumentRef docRef, LogEntry entry, String expectedFileSystemItemId) {
        DocumentModel doc = session.getDocument(docRef);
        FileSystemItem fsItem = null;
        try {
            fsItem = ((FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, false, false, false);
        }
        catch (RootlessItemException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((LogEntry)entry).getDocPath();
            supplierArray[1] = () -> docRef;
            log.debug("RootlessItemException thrown while trying to adapt document {} ({}) as a FileSystemItem.", supplierArray);
        }
        if (fsItem == null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((LogEntry)entry).getDocPath();
            supplierArray[1] = () -> docRef;
            log.debug("Document {} ({}) is not adaptable as a FileSystemItem, returning null.", supplierArray);
            return null;
        }
        if (expectedFileSystemItemId != null && !fsItem.getId().endsWith("#" + expectedFileSystemItemId)) {
            Supplier[] supplierArray = new Supplier[4];
            supplierArray[0] = fsItem::getId;
            supplierArray[1] = () -> ((LogEntry)entry).getDocPath();
            supplierArray[2] = () -> docRef;
            supplierArray[3] = () -> expectedFileSystemItemId;
            log.debug("Id {} of FileSystemItem adapted from document {} ({}) doesn't match expected FileSystemItem id {}, returning null.", supplierArray);
            return null;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((LogEntry)entry).getDocPath();
        supplierArray[1] = () -> docRef;
        log.debug("Document {} ({}) is adaptable as a FileSystemItem, providing it to the FileSystemItemChange entry.", supplierArray);
        return new FileSystemItemChangeImpl(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsItem);
    }

    private static /* synthetic */ Object lambda$getFileSystemChanges$4(DocumentRef docRef) {
        return docRef;
    }

    private static /* synthetic */ Object lambda$getFileSystemChanges$3(DocumentRef docRef) {
        return docRef;
    }

    private static /* synthetic */ Object lambda$getFileSystemChanges$2(DocumentRef docRef) {
        return docRef;
    }

    private static /* synthetic */ Object lambda$getFileSystemChanges$1(DocumentRef docRef) {
        return docRef;
    }

    private static /* synthetic */ Object lambda$getFileSystemChanges$0(DocumentRef docRef) {
        return docRef;
    }
}

