/*
 * Decompiled with CFR 0.152.
 */
package com.duosecurity;

import com.duosecurity.DuoWeb;
import junit.framework.TestCase;

public class DuoTest
extends TestCase {
    private static final String IKEY = "DIXXXXXXXXXXXXXXXXXX";
    private static final String SKEY = "deadbeefdeadbeefdeadbeefdeadbeefdeadbeef";
    private static final String AKEY = "useacustomerprovidedapplicationsecretkey";
    private static final String USER = "testuser";
    private static final String INVALID_RESPONSE = "AUTH|INVALID|SIG";
    private static final String EXPIRED_RESPONSE = "AUTH|dGVzdHVzZXJ8RElYWFhYWFhYWFhYWFhYWFhYWFh8MTMwMDE1Nzg3NA==|cb8f4d60ec7c261394cd5ee5a17e46ca7440d702";
    private static final String FUTURE_RESPONSE = "AUTH|dGVzdHVzZXJ8RElYWFhYWFhYWFhYWFhYWFhYWFh8MTYxNTcyNzI0Mw==|d20ad0d1e62d84b00a3e74ec201a5917e77b6aef";

    public void testSignRequest() {
        String request_sig = DuoWeb.signRequest(IKEY, SKEY, AKEY, USER);
        DuoTest.assertNotNull((Object)request_sig);
        request_sig = DuoWeb.signRequest(IKEY, SKEY, AKEY, "");
        DuoTest.assertEquals((String)request_sig, (String)"ERR|The username passed to sign_request() is invalid.");
        request_sig = DuoWeb.signRequest("invalid", SKEY, AKEY, USER);
        DuoTest.assertEquals((String)request_sig, (String)"ERR|The Duo integration key passed to sign_request() is invalid.");
        request_sig = DuoWeb.signRequest(IKEY, "invalid", AKEY, USER);
        DuoTest.assertEquals((String)request_sig, (String)"ERR|The Duo secret key passed to sign_request() is invalid.");
        request_sig = DuoWeb.signRequest(IKEY, SKEY, "invalid", USER);
        DuoTest.assertEquals((String)request_sig, (String)"ERR|The application secret key passed to sign_request() must be at least 40 characters.");
    }

    public void testVerifyResponse() {
        String request_sig = DuoWeb.signRequest(IKEY, SKEY, AKEY, USER);
        String[] sigs = request_sig.split(":");
        String valid_app_sig = sigs[1];
        request_sig = DuoWeb.signRequest(IKEY, SKEY, "invalidinvalidinvalidinvalidinvalidinvalid", USER);
        sigs = request_sig.split(":");
        String invalid_app_sig = sigs[1];
        String invalid_user = DuoWeb.verifyResponse(IKEY, SKEY, AKEY, "AUTH|INVALID|SIG:" + valid_app_sig);
        DuoTest.assertEquals((String)invalid_user, null);
        String expired_user = DuoWeb.verifyResponse(IKEY, SKEY, AKEY, "AUTH|dGVzdHVzZXJ8RElYWFhYWFhYWFhYWFhYWFhYWFh8MTMwMDE1Nzg3NA==|cb8f4d60ec7c261394cd5ee5a17e46ca7440d702:" + valid_app_sig);
        DuoTest.assertEquals((String)expired_user, null);
        String future_user = DuoWeb.verifyResponse(IKEY, SKEY, AKEY, "AUTH|dGVzdHVzZXJ8RElYWFhYWFhYWFhYWFhYWFhYWFh8MTYxNTcyNzI0Mw==|d20ad0d1e62d84b00a3e74ec201a5917e77b6aef:" + invalid_app_sig);
        DuoTest.assertEquals((String)future_user, null);
        future_user = DuoWeb.verifyResponse(IKEY, SKEY, AKEY, "AUTH|dGVzdHVzZXJ8RElYWFhYWFhYWFhYWFhYWFhYWFh8MTYxNTcyNzI0Mw==|d20ad0d1e62d84b00a3e74ec201a5917e77b6aef:" + valid_app_sig);
        DuoTest.assertEquals((String)future_user, (String)USER);
    }
}

