/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.duoweb.authentication;

import com.duosecurity.DuoWeb;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.login.LoginPlugin;
import org.nuxeo.ecm.platform.login.LoginPluginDescriptor;
import org.nuxeo.ecm.platform.login.LoginPluginRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.plugins.FormAuthenticator;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;

public class DuoFactorsAuthenticator
extends FormAuthenticator {
    private static final Log log = LogFactory.getLog(FormAuthenticator.class);
    protected static final Random RANDOM = new SecureRandom();
    private static final String DUO_FACTOR_PAGE = "duofactors.jsp";
    private static final String SIG_REQUEST = "sig_request";
    private static final String SIG_RESPONSE = "sig_response";
    private static final String HOST_REQUEST = "host";
    private static final String POST_ACTION = "post_action";
    private static final String ONE_FACTOR_CHECK = "oneFactorCheck";
    private static final String TWO_FACTORS_CHECK = "twoFactorsCheck";
    private static final String HASHCODE = "hash";
    protected static final Integer CACHE_CONCURRENCY_LEVEL = 10;
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    protected static final Integer CACHE_TIMEOUT = 4;
    private UserIdentificationInfo userIdent;
    private String IKEY;
    private String SKEY;
    private String AKEY;
    private String HOST;
    private Cache<String, UserIdentificationInfo> credentials = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.MINUTES).build();

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        HttpSession session = httpRequest.getSession(false);
        if (session == null || session.getAttribute(ONE_FACTOR_CHECK) == null || !((Boolean)session.getAttribute(ONE_FACTOR_CHECK)).booleanValue()) {
            if (session != null) {
                session.setAttribute("Nuxeo5_Start_Page", (Object)this.getRequestedUrl(httpRequest));
            }
            super.handleLoginPrompt(httpRequest, httpResponse, baseURL);
            return Boolean.TRUE;
        }
        if (((Boolean)session.getAttribute(ONE_FACTOR_CHECK)).booleanValue() && (session.getAttribute(TWO_FACTORS_CHECK) == null || !((Boolean)session.getAttribute(TWO_FACTORS_CHECK)).booleanValue())) {
            String redirectUrl = baseURL + DUO_FACTOR_PAGE;
            String postUrl = baseURL + LoginScreenHelper.getStartupPagePath();
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                String userName = httpRequest.getParameter(this.usernameKey);
                if (userName == null) {
                    session.setAttribute(ONE_FACTOR_CHECK, (Object)Boolean.FALSE);
                    return Boolean.FALSE;
                }
                String request_sig = DuoWeb.signRequest((String)this.IKEY, (String)this.SKEY, (String)this.AKEY, (String)userName);
                parameters.put(SIG_REQUEST, request_sig);
                parameters.put(HOST_REQUEST, this.HOST);
                String key = Integer.toHexString(this.userIdent.hashCode());
                this.credentials.put((Object)key, (Object)this.userIdent);
                parameters.put(POST_ACTION, postUrl + "?" + HASHCODE + "=" + key);
                parameters.put("requestedUrl", httpRequest.getParameter("requestedUrl"));
                redirectUrl = URIUtils.addParametersToURIQuery((String)redirectUrl, parameters);
                httpResponse.sendRedirect(redirectUrl);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return null;
        }
        if (session.getAttribute(ONE_FACTOR_CHECK) == null || !((Boolean)session.getAttribute(ONE_FACTOR_CHECK)).booleanValue()) {
            this.userIdent = super.handleRetrieveIdentity(httpRequest, httpResponse);
            session = httpRequest.getSession(true);
            if (this.userIdent != null) {
                try {
                    NuxeoPrincipal principal = this.validateUserIdentity();
                    if (principal != null) {
                        session.setAttribute(ONE_FACTOR_CHECK, (Object)Boolean.TRUE);
                        return null;
                    }
                    httpRequest.setAttribute("org.nuxeo.ecm.login.error", (Object)"loginFailed");
                    return null;
                }
                catch (LoginException e) {
                    log.error((Object)e, (Throwable)e);
                    return null;
                }
            }
            session.setAttribute(ONE_FACTOR_CHECK, (Object)Boolean.FALSE);
            return null;
        }
        if (session.getAttribute(TWO_FACTORS_CHECK) == null || !((Boolean)session.getAttribute(TWO_FACTORS_CHECK)).booleanValue()) {
            String sigResponse = httpRequest.getParameter(SIG_RESPONSE);
            String hashResponse = httpRequest.getParameter(HASHCODE);
            String response = DuoWeb.verifyResponse((String)this.IKEY, (String)this.SKEY, (String)this.AKEY, (String)sigResponse);
            this.userIdent = (UserIdentificationInfo)this.credentials.getIfPresent((Object)hashResponse);
            session.setAttribute(TWO_FACTORS_CHECK, (Object)(response != null ? Boolean.TRUE : Boolean.FALSE));
            if (response == null) {
                return null;
            }
            return this.userIdent;
        }
        return this.userIdent;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return true;
    }

    public void initPlugin(Map<String, String> parameters) {
        if (parameters.get("IKEY") != null) {
            this.IKEY = parameters.get("IKEY");
        }
        if (parameters.get("SKEY") != null) {
            this.SKEY = parameters.get("SKEY");
        }
        if (parameters.get("AKEY") != null) {
            this.AKEY = parameters.get("AKEY");
        }
        if (parameters.get("HOST") != null) {
            this.HOST = parameters.get("HOST");
        }
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public NuxeoPrincipal createIdentity(String username) throws LoginException {
        UserManager manager = (UserManager)Framework.getService(UserManager.class);
        log.debug((Object)("createIdentity: " + username));
        try {
            NuxeoPrincipalImpl principal;
            if (manager == null) {
                principal = new NuxeoPrincipalImpl(username);
            } else {
                principal = (NuxeoPrincipal)Framework.doPrivileged(() -> manager.getPrincipal(username));
                if (principal == null) {
                    throw new LoginException(String.format("principal %s does not exist", username));
                }
            }
            String principalId = String.valueOf(RANDOM.nextLong());
            principal.setPrincipalId(principalId);
            return principal;
        }
        catch (LoginException e) {
            log.error((Object)"createIdentity failed", (Throwable)e);
            LoginException le = new LoginException("createIdentity failed for user " + username);
            le.initCause(e);
            throw le;
        }
    }

    protected NuxeoPrincipal validateUserIdentity() throws LoginException {
        String username;
        UserManager manager = (UserManager)Framework.getService(UserManager.class);
        RuntimeService runtime = Framework.getRuntime();
        LoginPluginRegistry loginPluginManager = (LoginPluginRegistry)runtime.getComponent(LoginPluginRegistry.NAME);
        String loginPluginName = this.userIdent.getLoginPluginName();
        if (loginPluginName == null) {
            if (manager.checkUsernamePassword(this.userIdent.getUserName(), this.userIdent.getPassword())) {
                return this.createIdentity(this.userIdent.getUserName());
            }
            return null;
        }
        LoginPlugin lp = loginPluginManager.getPlugin(loginPluginName);
        if (lp == null) {
            log.error((Object)"Can't authenticate against a null loginModule plugin");
            return null;
        }
        LoginPluginDescriptor lpd = loginPluginManager.getPluginDescriptor(loginPluginName);
        if (!lpd.getInitialized()) {
            boolean init;
            Map loginParams;
            HashMap existingParams = lp.getParameters();
            if (existingParams == null) {
                existingParams = new HashMap();
            }
            if ((loginParams = this.userIdent.getLoginParameters()) != null) {
                existingParams.putAll(loginParams);
            }
            if (init = lp.initLoginModule().booleanValue()) {
                lpd.setInitialized(true);
            } else {
                log.error((Object)("Unable to initialize LoginModulePlugin " + lp.getName()));
                return null;
            }
        }
        if ((username = lp.validatedUserIdentity(this.userIdent)) == null) {
            return null;
        }
        return this.createIdentity(username);
    }

    protected String getRequestedUrl(HttpServletRequest httpRequest) {
        String completeURI = httpRequest.getRequestURI();
        String qs = httpRequest.getQueryString();
        String context = httpRequest.getContextPath() + '/';
        String requestPage = completeURI.substring(context.length());
        if (qs != null && qs.length() > 0) {
            if (qs.contains("conversationId")) {
                qs = qs.replace("conversationId", "old_conversationId");
            }
            requestPage = requestPage + '?' + qs;
        }
        return requestPage;
    }
}

