/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.pub.endpoint;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.api.TransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/public/transform")
@WebObject(type="publicTransform")
@Produces(value={"text/html;charset=UTF-8"})
public class Transform {
    private static final Logger log = LogManager.getLogger(Transform.class);

    @GET
    @Path(value="/{repository}/{id}")
    public Object getTransform(@PathParam(value="repository") String repository, @PathParam(value="id") String documentId, @QueryParam(value="width") long width, @QueryParam(value="height") long height, @QueryParam(value="format") String format, @QueryParam(value="crop") String crop, @QueryParam(value="autoCropRatio") double autoCropRatio) {
        return Framework.doPrivileged(() -> {
            CoreSession session = CoreInstance.getCoreSessionSystem((String)repository);
            DocumentModel document = session.getDocument((DocumentRef)new IdRef(documentId));
            PublicDownloadLinkService downloadLinkService = (PublicDownloadLinkService)Framework.getService(PublicDownloadLinkService.class);
            if (!downloadLinkService.hasPublicDownloadPermission(document, "file:content")) {
                return this.buildError(Response.Status.NOT_FOUND);
            }
            DynamicTransformationService service = (DynamicTransformationService)Framework.getService(DynamicTransformationService.class);
            Transformation transformation = new TransformationBuilder(document).width(width).height(height).cropBox(crop).cropRatio(autoCropRatio).format(format).build();
            Blob renditionBlob = service.transform(document, transformation);
            TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
            TransientStore store = transientStoreService.getStore("image-transformation");
            String key = document.getId() + transformation;
            store.putBlobs(key, List.of(renditionBlob));
            store.setCompleted(key, true);
            return store.getBlobs(key).get(0);
        });
    }

    private Response buildError(Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)"Invalid request.").type("text/plain").build();
    }
}

