/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.service;

import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.runtime.api.Framework;

public class DynamicTransformationServiceImpl
implements DynamicTransformationService {
    @Override
    public Blob transform(DocumentModel doc, Transformation transformation) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        ConversionService converterService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = converterService.convert("dynamicImageResizer", (BlobHolder)new SimpleBlobHolder(blob), transformation.toMap());
        Blob resultBlob = result.getBlob();
        String name = FilenameUtils.removeExtension((String)blob.getFilename());
        resultBlob.setFilename(String.format("%s_%dx%d.%s", name, transformation.getWidth(), transformation.getHeight(), transformation.getFormat()));
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = registry.getMimetypeFromExtension(transformation.getFormat());
        resultBlob.setMimeType(mimetype);
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore("image-transformation");
        String key = doc.getId() + transformation;
        store.putBlobs(key, result.getBlobs());
        store.setCompleted(key, true);
        return (Blob)store.getBlobs(key).get(0);
    }
}

