/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CropBox {
    static Pattern p = Pattern.compile("([0-9]*),([0-9]*),([0-9]*),([0-9]*)");
    int top;
    int left;
    int width;
    int height;

    public CropBox(String crop) {
        Matcher m = p.matcher(crop);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid crop format");
        }
        this.top = Integer.parseInt(m.group(4));
        this.left = Integer.parseInt(m.group(3));
        this.width = Integer.parseInt(m.group(1));
        this.height = Integer.parseInt(m.group(2));
    }

    public CropBox(int top, int left, int width, int height) {
        this.top = top;
        this.left = left;
        this.width = width;
        this.height = height;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return String.format("%dx%d+%d+%d", this.width, this.height, this.left, this.top);
    }
}

