/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.api;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.api.TransformationImpl;

public class TransformationBuilder {
    protected ImageInfo imageInfo;
    protected int width = 0;
    protected int height = 0;
    protected String format;
    protected CropBox cropBox = null;

    public TransformationBuilder(DocumentModel doc) {
        if (!doc.hasFacet("Picture")) {
            throw new IllegalArgumentException("doc is Not a Picture document");
        }
        this.imageInfo = ImageInfo.fromMap((Map)((Map)((Object)doc.getPropertyValue("picture:info"))));
    }

    public TransformationBuilder(ImageInfo info) {
        this.imageInfo = info;
    }

    public TransformationBuilder width(int width) {
        this.width = width;
        return this;
    }

    public TransformationBuilder height(int height) {
        this.height = height;
        return this;
    }

    public TransformationBuilder format(String format) {
        this.format = format;
        return this;
    }

    public TransformationBuilder cropBox(CropBox box) {
        this.cropBox = box;
        return this;
    }

    public TransformationBuilder cropBox(String crop) {
        this.cropBox = crop != null ? new CropBox(crop) : null;
        return this;
    }

    public Transformation build() {
        TransformationImpl transformation = new TransformationImpl();
        if (this.cropBox == null) {
            this.cropBox = new CropBox(0, 0, this.imageInfo.getWidth(), this.imageInfo.getHeight());
        }
        transformation.setCropBox(this.cropBox);
        float imageRatio = (float)this.cropBox.getWidth() * 1.0f / (float)this.cropBox.getHeight();
        if (this.width <= 0 && this.height <= 0) {
            this.width = this.cropBox.getWidth();
            this.height = this.cropBox.getHeight();
        } else if (this.width <= 0) {
            this.width = (int)((float)this.height * imageRatio);
        } else if (this.height <= 0) {
            this.height = (int)((float)this.width * (1.0f / imageRatio));
        }
        transformation.setWidth(this.width);
        transformation.setHeight(this.height);
        transformation.setFormat(StringUtils.isNotEmpty((CharSequence)this.format) ? this.format : "jpg");
        return transformation;
    }
}

