/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.api.TransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/transform")
@WebObject(type="transform")
@Produces(value={"application/json"})
public class TransformObject
extends DefaultObject {
    @GET
    @Path(value="/{id}")
    public Object getTransform(@PathParam(value="id") String documentId, @QueryParam(value="width") long width, @QueryParam(value="height") long height, @QueryParam(value="format") String format, @QueryParam(value="crop") String crop, @QueryParam(value="autoCropRatio") double autoCropRatio) {
        CoreSession session = this.getContext().getCoreSession();
        DocumentModel document = session.getDocument((DocumentRef)new IdRef(documentId));
        DynamicTransformationService service = (DynamicTransformationService)Framework.getService(DynamicTransformationService.class);
        Transformation transformation = new TransformationBuilder(document).width(width).height(height).cropBox(crop).cropRatio(autoCropRatio).format(format).build();
        return service.transform(document, transformation);
    }
}

