/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.impl.builder;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.impl.VideoTransformationImpl;
import org.nuxeo.labs.asset.transformation.impl.builder.AbstractTransformationBuilder;

public class VideoTransformationBuilder
extends AbstractTransformationBuilder<VideoTransformationBuilder, VideoTransformationImpl> {
    protected DocumentModel doc;
    protected VideoInfo videoInfo;
    protected String videoCodec;
    protected String audioCodec;
    protected long fromTimeInMs;
    protected long toTimeInMs;

    public VideoTransformationBuilder(DocumentModel doc) {
        if (!doc.hasFacet("Video")) {
            throw new IllegalArgumentException("doc is Not a Video document");
        }
        this.doc = doc;
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        this.videoInfo = videoDocument.getVideo().getVideoInfo();
    }

    public VideoTransformationBuilder(VideoInfo info) {
        this.videoInfo = info;
    }

    @Override
    public VideoTransformationBuilder getThis() {
        return this;
    }

    public VideoTransformationBuilder fromTimeInMs(long fromTimeInMs) {
        this.fromTimeInMs = fromTimeInMs;
        return this;
    }

    public VideoTransformationBuilder toTimeInMs(long toTimeInMs) {
        this.toTimeInMs = toTimeInMs;
        return this;
    }

    public VideoTransformationBuilder videoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
        return this;
    }

    public VideoTransformationBuilder audioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
        return this;
    }

    @Override
    public VideoTransformationImpl build() {
        VideoTransformationImpl transformation = (VideoTransformationImpl)super.build();
        if (StringUtils.isBlank((CharSequence)this.videoCodec)) {
            switch (transformation.getFormat()) {
                case "mp4": {
                    transformation.setVideoCodec("libx264");
                    break;
                }
                case "webm": {
                    transformation.setVideoCodec("libvpx-vp9");
                    break;
                }
                default: {
                    throw new NuxeoException("no default codec for format " + transformation.getFormat());
                }
            }
        } else {
            transformation.setVideoCodec(this.videoCodec);
        }
        if (StringUtils.isBlank((CharSequence)this.audioCodec)) {
            switch (transformation.getFormat()) {
                case "mp4": {
                    transformation.setAudioCodec("aac");
                    break;
                }
                case "webm": {
                    transformation.setAudioCodec("libvorbis");
                    break;
                }
                default: {
                    throw new NuxeoException("no default audio for format " + transformation.getFormat());
                }
            }
        } else {
            transformation.setAudioCodec(this.audioCodec);
        }
        return transformation;
    }

    @Override
    protected VideoTransformationImpl getNewEmptyTransformation() {
        return new VideoTransformationImpl();
    }

    @Override
    protected CropBox getCropBox() {
        if (this.cropRatio > 0.0) {
            return new CropBox(this.videoInfo, this.cropRatio);
        }
        return new CropBox(0L, 0L, this.videoInfo.getWidth(), this.videoInfo.getHeight());
    }

    @Override
    protected String getDefaultFormat() {
        return "mp4";
    }

    @Override
    protected String getDefaultColorSpace() {
        return "sRGB";
    }

    @Override
    protected String getDefaultBackgroundColor() {
        return "transparent";
    }

    @Override
    protected int getDefaultCompressionLevel() {
        return 30;
    }
}

