/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.impl.builder;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.api.Transformation;

public abstract class AbstractTransformationBuilder<T extends AbstractTransformationBuilder<T, V>, V extends Transformation> {
    protected long width = 0L;
    protected long height = 0L;
    protected String format;
    protected CropBox cropBox = null;
    protected double cropRatio = 0.0;
    protected String textWatermark = null;
    protected Blob imageWatermark = null;
    protected String watermarkId = null;
    protected String watermarkGravity = null;
    protected String colorSpace = null;
    protected String backgroundColor = null;
    protected int compressionLevel = 0;

    public abstract T getThis();

    public T width(long width) {
        this.width = width;
        return this.getThis();
    }

    public T height(long height) {
        this.height = height;
        return this.getThis();
    }

    public T format(String format) {
        this.format = format;
        return this.getThis();
    }

    public T cropBox(CropBox box) {
        this.cropBox = box;
        return this.getThis();
    }

    public T cropRatio(double ratio) {
        this.cropRatio = ratio;
        return this.getThis();
    }

    public T cropRatio(String ratio) {
        if (StringUtils.isNotEmpty((CharSequence)ratio)) {
            this.cropRatio = Double.parseDouble(ratio);
        }
        return this.getThis();
    }

    public T cropBox(String crop) {
        this.cropBox = crop != null ? new CropBox(crop) : null;
        return this.getThis();
    }

    public T textWatermark(String text) {
        this.textWatermark = text;
        return this.getThis();
    }

    public T imageWatermark(Blob image) {
        this.imageWatermark = image;
        return this.getThis();
    }

    public T watermarkId(String watermarkId) {
        this.watermarkId = watermarkId;
        return this.getThis();
    }

    public T watermarkGravity(String gravity) {
        this.watermarkGravity = gravity;
        return this.getThis();
    }

    public T colorSpace(String colorSpace) {
        this.colorSpace = colorSpace;
        return this.getThis();
    }

    public T backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this.getThis();
    }

    public T compressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this.getThis();
    }

    public V build() {
        V transformation = this.getNewEmptyTransformation();
        if (this.cropBox == null) {
            this.cropBox = this.getCropBox();
        }
        transformation.setCropBox(this.cropBox);
        double imageRatio = this.cropBox.getRatio();
        if (this.width <= 0L && this.height <= 0L) {
            this.width = this.cropBox.getWidth();
            this.height = this.cropBox.getHeight();
        } else if (this.width <= 0L) {
            this.width = (int)((double)this.height * imageRatio);
        } else if (this.height <= 0L) {
            this.height = (int)((double)this.width * (1.0 / imageRatio));
        }
        transformation.setWidth(this.width);
        transformation.setHeight(this.height);
        transformation.setFormat(StringUtils.isNotEmpty((CharSequence)this.format) ? this.format : this.getDefaultFormat());
        transformation.setTextWatermark(this.textWatermark);
        transformation.setImageWatermark(this.imageWatermark);
        transformation.setWatermarkId(this.watermarkId);
        transformation.setWatermarkGravity(StringUtils.isNotEmpty((CharSequence)this.watermarkGravity) ? this.watermarkGravity : this.getDefaultWatermarkGravity());
        transformation.setColorSpace(StringUtils.isNotEmpty((CharSequence)this.colorSpace) ? this.colorSpace : this.getDefaultColorSpace());
        transformation.setBackgroundColor(StringUtils.isNotEmpty((CharSequence)this.backgroundColor) ? this.backgroundColor : this.getDefaultBackgroundColor());
        transformation.setCompressionLevel(this.compressionLevel > 0 ? this.compressionLevel : this.getDefaultCompressionLevel());
        return transformation;
    }

    protected String getDefaultWatermarkGravity() {
        return "tile";
    }

    protected abstract V getNewEmptyTransformation();

    protected abstract CropBox getCropBox();

    protected abstract String getDefaultFormat();

    protected abstract String getDefaultColorSpace();

    protected abstract String getDefaultBackgroundColor();

    protected abstract int getDefaultCompressionLevel();
}

