/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;

public class CropBox {
    static Pattern p = Pattern.compile("([0-9]*),([0-9]*),([0-9]*),([0-9]*)");
    long top;
    long left;
    long width;
    long height;

    public CropBox(String crop) {
        Matcher m = p.matcher(crop);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid crop format");
        }
        this.top = Long.parseLong(m.group(4));
        this.left = Long.parseLong(m.group(3));
        this.width = Long.parseLong(m.group(1));
        this.height = Long.parseLong(m.group(2));
    }

    public CropBox(long top, long left, long width, long height) {
        this.top = top;
        this.left = left;
        this.width = width;
        this.height = height;
    }

    public CropBox(Map<String, Serializable> map) {
        this.top = (Long)map.get("top");
        this.left = (Long)map.get("left");
        this.width = (Long)map.get("width");
        this.height = (Long)map.get("height");
    }

    public CropBox(ImageInfo imageInfo, double cropRatio) {
        this(0L, 0L, imageInfo.getWidth(), imageInfo.getHeight());
        double originalRatio = this.getRatio();
        if (originalRatio == cropRatio) {
            return;
        }
        if (this.width < this.height) {
            cropRatio = 1.0 / cropRatio;
        }
        if (originalRatio < cropRatio) {
            int targetHeight = (int)Math.round((double)this.width / cropRatio);
            this.top = (this.height - (long)targetHeight) / 2L;
            this.height = targetHeight;
        } else {
            int targetWidth = (int)Math.round((double)this.height * cropRatio);
            this.left = (this.width - (long)targetWidth) / 2L;
            this.width = targetWidth;
        }
    }

    public long getTop() {
        return this.top;
    }

    public long getLeft() {
        return this.left;
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public double getRatio() {
        return (double)this.width * 1.0 / (double)this.height;
    }

    public String toString() {
        return String.format("%dx%d+%d+%d", this.width, this.height, this.left, this.top);
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("top", Long.valueOf(this.top));
        map.put("left", Long.valueOf(this.left));
        map.put("width", Long.valueOf(this.width));
        map.put("height", Long.valueOf(this.height));
        return map;
    }
}

