/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.api.TransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;

@Operation(id="Blob.ImageTransform", category="Document", label="Image Transformation", description="Perform image transformation such as crop, resize and format")
public class ImageTransformOp {
    public static final String ID = "Blob.ImageTransform";
    @Param(name="width", required=false)
    long width;
    @Param(name="height", required=false)
    long height;
    @Param(name="format", required=false)
    String format;
    @Param(name="crop", required=false)
    String crop;
    @Param(name="autoCropRatio", required=false)
    double autoCropRatio;
    @Context
    DynamicTransformationService transformationService;

    @OperationMethod
    public Blob run(DocumentModel document) {
        Transformation transformation = new TransformationBuilder(document).width(this.width).height(this.height).cropBox(this.crop).cropRatio(this.autoCropRatio).format(this.format).build();
        return this.transformationService.transform(document, transformation);
    }
}

