/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.service;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.runtime.api.Framework;

public class DynamicTransformationServiceImpl
implements DynamicTransformationService {
    @Override
    public Blob transform(DocumentModel doc, Transformation transformation) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder conversionResult = conversionService.convert("dynamicImageResizer", (BlobHolder)new SimpleBlobHolder(blob), transformation.toMap());
        Blob convertedBlob = conversionResult.getBlob();
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = registry.getMimetypeFromExtension(transformation.getFormat());
        convertedBlob.setFilename(this.getTargetFileName(blob, transformation));
        convertedBlob.setMimeType(mimetype);
        Blob watermarkBlob = this.getWatermarkBlob(transformation);
        if (watermarkBlob == null) {
            return convertedBlob;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("format", transformation.getFormat());
            params.put("watermarkFilePath", watermarkBlob.getCloseableFile().file.getPath());
            BlobHolder watermarkResult = conversionService.convert("composeWatermarkedImage", (BlobHolder)new SimpleBlobHolder(convertedBlob), params);
            Blob watermarkedBlob = watermarkResult.getBlob();
            watermarkedBlob.setFilename(this.getTargetFileName(blob, transformation));
            watermarkedBlob.setMimeType(mimetype);
            return watermarkedBlob;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public Blob getWatermarkBlob(Transformation transformation) {
        if (StringUtils.isNotEmpty((CharSequence)transformation.getTextWatermark())) {
            return this.getWatermarkBlobFromText(transformation);
        }
        return transformation.getImageWatermark();
    }

    public Blob getWatermarkBlobFromText(Transformation transformation) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = conversionService.convert("text2WatermarkImage", (BlobHolder)new SimpleBlobHolder((Blob)new StringBlob(transformation.getTextWatermark())), transformation.toMap());
        return result.getBlob();
    }

    public String getTargetFileName(Blob blob, Transformation transformation) {
        String name = FilenameUtils.removeExtension((String)blob.getFilename());
        return String.format("%s_%dx%d.%s", name, transformation.getWidth(), transformation.getHeight(), transformation.getFormat());
    }
}

