/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.api.CropDocumentAdapter;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.api.TransformationImpl;

public class TransformationBuilder {
    protected DocumentModel doc;
    protected ImageInfo imageInfo;
    protected long width = 0L;
    protected long height = 0L;
    protected String format;
    protected CropBox cropBox = null;
    protected double cropRatio = 0.0;
    protected Map<String, CropBox> cropPresets = new HashMap<String, CropBox>();
    protected String textWatermark = null;
    protected Blob imageWatermark = null;

    public TransformationBuilder(DocumentModel doc) {
        if (!doc.hasFacet("Picture")) {
            throw new IllegalArgumentException("doc is Not a Picture document");
        }
        this.doc = doc;
        this.imageInfo = ImageInfo.fromMap((Map)((Map)((Object)doc.getPropertyValue("picture:info"))));
        CropDocumentAdapter adapter = (CropDocumentAdapter)doc.getAdapter(CropDocumentAdapter.class);
        if (adapter != null) {
            this.cropPresets = adapter.getCrops();
        }
    }

    protected TransformationBuilder(ImageInfo info) {
        this.imageInfo = info;
    }

    protected TransformationBuilder(ImageInfo info, Map<String, CropBox> cropPresets) {
        this.imageInfo = info;
        this.cropPresets = cropPresets;
    }

    public TransformationBuilder width(long width) {
        this.width = width;
        return this;
    }

    public TransformationBuilder height(long height) {
        this.height = height;
        return this;
    }

    public TransformationBuilder format(String format) {
        this.format = format;
        return this;
    }

    public TransformationBuilder cropBox(CropBox box) {
        this.cropBox = box;
        return this;
    }

    public TransformationBuilder cropRatio(double ratio) {
        this.cropRatio = ratio;
        return this;
    }

    public TransformationBuilder cropBox(String crop) {
        this.cropBox = crop != null ? new CropBox(crop) : null;
        return this;
    }

    public TransformationBuilder textWatermark(String text) {
        this.textWatermark = text;
        return this;
    }

    public TransformationBuilder imageWatermark(Blob image) {
        this.imageWatermark = image;
        return this;
    }

    public Transformation build() {
        TransformationImpl transformation = new TransformationImpl();
        if (this.cropBox == null) {
            CropBox box;
            this.cropBox = this.cropRatio > 0.0 ? ((box = this.cropPresets.get(String.format("%.2f", this.cropRatio))) != null ? box : new CropBox(this.imageInfo, this.cropRatio)) : new CropBox(0L, 0L, this.imageInfo.getWidth(), this.imageInfo.getHeight());
        }
        transformation.setCropBox(this.cropBox);
        double imageRatio = this.cropBox.getRatio();
        if (this.width <= 0L && this.height <= 0L) {
            this.width = this.cropBox.getWidth();
            this.height = this.cropBox.getHeight();
        } else if (this.width <= 0L) {
            this.width = (int)((double)this.height * imageRatio);
        } else if (this.height <= 0L) {
            this.height = (int)((double)this.width * (1.0 / imageRatio));
        }
        transformation.setWidth(this.width);
        transformation.setHeight(this.height);
        transformation.setFormat(StringUtils.isNotEmpty((CharSequence)this.format) ? this.format : "jpg");
        transformation.setTextWatermark(this.textWatermark);
        transformation.setImageWatermark(this.imageWatermark);
        return transformation;
    }
}

