/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.impl.builder.ImageTransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/transform")
@WebObject(type="transform")
@Produces(value={"application/json"})
public class TransformObject
extends DefaultObject {
    public static final String DOWNLOAD_URL = "downloadUrl";

    @GET
    @Path(value="/{id}")
    public Object getTransform(@HeaderParam(value="accept") String acceptHeader, @PathParam(value="id") String documentId, @QueryParam(value="width") long width, @QueryParam(value="height") long height, @QueryParam(value="format") String format, @QueryParam(value="crop") String crop, @QueryParam(value="autoCropRatio") double autoCropRatio, @QueryParam(value="textWatermark") String textWatermark) {
        boolean acceptJson = false;
        if (StringUtils.isNotBlank((CharSequence)acceptHeader)) {
            List<String> types = Arrays.asList(acceptHeader.split(","));
            acceptJson = types.contains("application/json");
        }
        CoreSession session = this.getContext().getCoreSession();
        DocumentModel document = session.getDocument((DocumentRef)new IdRef(documentId));
        DynamicTransformationService service = (DynamicTransformationService)Framework.getService(DynamicTransformationService.class);
        Transformation transformation = new ImageTransformationBuilder(document).width(width).height(height).cropBox(crop).cropRatio(autoCropRatio).format(format).textWatermark(textWatermark).build();
        Blob result = service.transform(document, transformation);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String key = downloadService.storeBlobs(List.of(result));
        String downloadPath = downloadService.getDownloadUrl(key);
        String baseUrl = Framework.getProperty((String)"nuxeo.url");
        String fullUrl = String.format("%s/%s", baseUrl, downloadPath);
        if (acceptJson) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(DOWNLOAD_URL, (Object)fullUrl);
            return new StringBlob(jsonObject.toString(), "application/json");
        }
        return Response.status((int)302).location(URI.create(fullUrl)).build();
    }
}

