/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.api.Transformation;

public class ImageTransformationImpl
implements Transformation {
    protected long width;
    protected long height;
    protected String format;
    protected CropBox cropBox;
    protected double ratio;
    protected String textWatermark;
    protected Blob imageWatermark;

    @Override
    public long getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(long width) {
        this.width = width;
    }

    @Override
    public long getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(long height) {
        this.height = height;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public CropBox getCropBox() {
        return this.cropBox;
    }

    @Override
    public void setCropBox(CropBox box) {
        this.cropBox = box;
        this.ratio = this.cropBox.getRatio();
    }

    @Override
    public double getCropRatio() {
        return this.ratio;
    }

    @Override
    public void setCropRatio(double ratio) {
        this.ratio = ratio;
    }

    @Override
    public String getTextWatermark() {
        return this.textWatermark;
    }

    @Override
    public void setTextWatermark(String textWatermark) {
        this.textWatermark = textWatermark;
    }

    @Override
    public Blob getImageWatermark() {
        return this.imageWatermark;
    }

    @Override
    public void setImageWatermark(Blob imageWatermark) {
        this.imageWatermark = imageWatermark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageTransformationImpl that = (ImageTransformationImpl)o;
        return this.width == that.width && this.height == that.height && Double.compare(that.ratio, this.ratio) == 0 && Objects.equals(this.format, that.format) && Objects.equals(this.cropBox, that.cropBox) && Objects.equals(this.textWatermark, that.textWatermark) && Objects.equals(this.imageWatermark, that.imageWatermark);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.format, this.cropBox, this.ratio, this.textWatermark, this.imageWatermark);
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("width", (Serializable)((Object)("" + this.width)));
        map.put("height", (Serializable)((Object)("" + this.height)));
        map.put("format", (Serializable)((Object)this.format));
        map.put("crop", (Serializable)((Object)this.cropBox.toString()));
        map.put("textWatermark", (Serializable)((Object)this.textWatermark));
        return map;
    }
}

