/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.impl.builder;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.impl.ImageTransformationImpl;

public abstract class AbstractTransformationBuilder {
    protected long width = 0L;
    protected long height = 0L;
    protected String format;
    protected CropBox cropBox = null;
    protected double cropRatio = 0.0;
    protected String textWatermark = null;
    protected Blob imageWatermark = null;

    public AbstractTransformationBuilder width(long width) {
        this.width = width;
        return this;
    }

    public AbstractTransformationBuilder height(long height) {
        this.height = height;
        return this;
    }

    public AbstractTransformationBuilder format(String format) {
        this.format = format;
        return this;
    }

    public AbstractTransformationBuilder cropBox(CropBox box) {
        this.cropBox = box;
        return this;
    }

    public AbstractTransformationBuilder cropRatio(double ratio) {
        this.cropRatio = ratio;
        return this;
    }

    public AbstractTransformationBuilder cropBox(String crop) {
        this.cropBox = crop != null ? new CropBox(crop) : null;
        return this;
    }

    public AbstractTransformationBuilder textWatermark(String text) {
        this.textWatermark = text;
        return this;
    }

    public AbstractTransformationBuilder imageWatermark(Blob image) {
        this.imageWatermark = image;
        return this;
    }

    public Transformation build() {
        ImageTransformationImpl transformation = new ImageTransformationImpl();
        if (this.cropBox == null) {
            this.cropBox = this.getCropBox();
        }
        transformation.setCropBox(this.cropBox);
        double imageRatio = this.cropBox.getRatio();
        if (this.width <= 0L && this.height <= 0L) {
            this.width = this.cropBox.getWidth();
            this.height = this.cropBox.getHeight();
        } else if (this.width <= 0L) {
            this.width = (int)((double)this.height * imageRatio);
        } else if (this.height <= 0L) {
            this.height = (int)((double)this.width * (1.0 / imageRatio));
        }
        transformation.setWidth(this.width);
        transformation.setHeight(this.height);
        transformation.setFormat(StringUtils.isNotEmpty((CharSequence)this.format) ? this.format : this.getDefaultFormat());
        transformation.setTextWatermark(this.textWatermark);
        transformation.setImageWatermark(this.imageWatermark);
        return transformation;
    }

    protected abstract CropBox getCropBox();

    protected abstract String getDefaultFormat();
}

