/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.impl.builder;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.impl.builder.AbstractTransformationBuilder;

public class VideoTransformationBuilder
extends AbstractTransformationBuilder {
    protected DocumentModel doc;
    protected VideoInfo videoInfo;

    public VideoTransformationBuilder(DocumentModel doc) {
        if (!doc.hasFacet("Video")) {
            throw new IllegalArgumentException("doc is Not a Video document");
        }
        this.doc = doc;
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        this.videoInfo = videoDocument.getVideo().getVideoInfo();
    }

    public VideoTransformationBuilder(VideoInfo info) {
        this.videoInfo = info;
    }

    @Override
    protected CropBox getCropBox() {
        return new CropBox(0L, 0L, this.videoInfo.getWidth(), this.videoInfo.getHeight());
    }

    @Override
    protected String getDefaultFormat() {
        return "mp4";
    }
}

