/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.impl.builder;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.labs.asset.transformation.adapter.CropDocumentAdapter;
import org.nuxeo.labs.asset.transformation.api.CropBox;
import org.nuxeo.labs.asset.transformation.impl.Constants;
import org.nuxeo.labs.asset.transformation.impl.builder.AbstractTransformationBuilder;

public class ImageTransformationBuilder
extends AbstractTransformationBuilder {
    protected DocumentModel doc;
    protected ImageInfo imageInfo;
    protected Map<String, CropBox> cropPresets = new HashMap<String, CropBox>();

    public ImageTransformationBuilder(DocumentModel doc) {
        if (!doc.hasFacet("Picture")) {
            throw new IllegalArgumentException("doc is Not a Picture document");
        }
        this.doc = doc;
        this.imageInfo = ImageInfo.fromMap((Map)((Map)((Object)doc.getPropertyValue("picture:info"))));
        CropDocumentAdapter adapter = (CropDocumentAdapter)doc.getAdapter(CropDocumentAdapter.class);
        if (adapter != null) {
            this.cropPresets = adapter.getCrops();
        }
    }

    public ImageTransformationBuilder(ImageInfo info) {
        this.imageInfo = info;
    }

    public ImageTransformationBuilder(ImageInfo info, Map<String, CropBox> cropPresets) {
        this.imageInfo = info;
        this.cropPresets = cropPresets;
    }

    @Override
    protected CropBox getCropBox() {
        if (this.cropRatio > 0.0) {
            CropBox box = this.cropPresets.get(String.format("%.2f", this.cropRatio));
            return box != null ? box : new CropBox(this.imageInfo, this.cropRatio);
        }
        return new CropBox(0L, 0L, this.imageInfo.getWidth(), this.imageInfo.getHeight());
    }

    @Override
    protected String getDefaultFormat() {
        return Constants.JPG;
    }

    @Override
    protected String getDefaultColorSpace() {
        return Constants.SRGB;
    }

    @Override
    protected String getDefaultBackgroundColor() {
        return Constants.TRANSPARENT;
    }

    @Override
    protected int getDefaultCompressionLevel() {
        return 90;
    }
}

