/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.impl.builder.VideoTransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;

@Operation(id="Blob.VideoTransform", category="Document", label="Video Transformation", description="Perform video transformation such as resize and format change")
public class VideoTransformOp {
    public static final String ID = "Blob.VideoTransform";
    @Param(name="width", required=false)
    long width;
    @Param(name="height", required=false)
    long height;
    @Param(name="format", required=false)
    String format;
    @Param(name="crop", required=false)
    String crop;
    @Param(name="textWatermark", required=false)
    String textWatermark;
    @Param(name="imageWatermark", required=false)
    Blob imageWatermark;
    @Context
    DynamicTransformationService transformationService;

    @OperationMethod
    public Blob run(DocumentModel document) {
        VideoDocument videoDocument = (VideoDocument)document.getAdapter(VideoDocument.class);
        Transformation transformation = new VideoTransformationBuilder(document).width(this.width).height(this.height).cropBox(this.crop).format(this.format).textWatermark(this.textWatermark).imageWatermark(this.imageWatermark).build();
        return this.transformationService.transformVideo(videoDocument.getVideo(), transformation);
    }
}

