/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.labs.asset.transformation.impl.VideoTransformationImpl;
import org.nuxeo.labs.asset.transformation.impl.builder.VideoTransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;

@Operation(id="Blob.VideoTransform", category="Document", label="Video Transformation", description="Perform video transformation such as resize and format change")
public class VideoTransformOp {
    public static final String ID = "Blob.VideoTransform";
    @Param(name="width", required=false)
    long width;
    @Param(name="height", required=false)
    long height;
    @Param(name="format", required=false)
    String format;
    @Param(name="videoCodec", required=false)
    String videoCodec;
    @Param(name="audioCodec", required=false)
    String auidoCodec;
    @Param(name="autoCropRatio", required=false)
    String autoCropRatio;
    @Param(name="crop", required=false)
    String crop;
    @Param(name="textWatermark", required=false)
    String textWatermark;
    @Param(name="imageWatermark", required=false)
    Blob imageWatermark;
    @Param(name="compressionLevel", required=false)
    int compressionLevel;
    @Context
    DynamicTransformationService transformationService;

    @OperationMethod
    public Blob run(DocumentModel document) {
        VideoDocument videoDocument = (VideoDocument)document.getAdapter(VideoDocument.class);
        VideoTransformationImpl transformation = ((VideoTransformationBuilder)((VideoTransformationBuilder)((VideoTransformationBuilder)((VideoTransformationBuilder)((VideoTransformationBuilder)((VideoTransformationBuilder)((VideoTransformationBuilder)((VideoTransformationBuilder)new VideoTransformationBuilder(document).videoCodec(this.videoCodec).audioCodec(this.auidoCodec).width(this.width)).height(this.height)).cropRatio(this.autoCropRatio)).cropBox(this.crop)).format(this.format)).textWatermark(this.textWatermark)).imageWatermark(this.imageWatermark)).compressionLevel(this.compressionLevel)).build();
        return this.transformationService.transformVideo(videoDocument.getVideo(), transformation);
    }
}

