/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.adapter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.asset.transformation.api.CropBox;

public class CropDocumentAdapter {
    public static final String CROPS_PROPERTY = "crops:crops";
    public static final String CROP_NAME_SUBPROPERTY = "name";
    protected DocumentModel doc;

    public CropDocumentAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public Map<String, CropBox> getCrops() {
        HashMap<String, CropBox> result = new HashMap<String, CropBox>();
        List crops = (List)((Object)this.doc.getPropertyValue(CROPS_PROPERTY));
        for (Map crop : crops) {
            result.put((String)crop.get(CROP_NAME_SUBPROPERTY), new CropBox(crop));
        }
        return result;
    }

    public CropBox getCropByName(String name) {
        List crops = (List)((Object)this.doc.getPropertyValue(CROPS_PROPERTY));
        return (crops = crops.stream().filter(element -> name.equals(element.get(CROP_NAME_SUBPROPERTY))).collect(Collectors.toList())).size() > 0 ? new CropBox((Map)crops.get(0)) : null;
    }

    public void addCrop(String name, CropBox box) {
        Map<String, CropBox> crops = this.getCrops();
        crops.put(name, box);
        this.saveCrops(crops);
    }

    public void saveCrops(Map<String, CropBox> crops) {
        List values = crops.entrySet().stream().map(entry -> {
            Map<String, Serializable> map = ((CropBox)entry.getValue()).toMap();
            map.put(CROP_NAME_SUBPROPERTY, (Serializable)entry.getKey());
            return map;
        }).collect(Collectors.toList());
        this.doc.setPropertyValue(CROPS_PROPERTY, (Serializable)((Object)values));
    }
}

