/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.impl.Constants;
import org.nuxeo.labs.asset.transformation.impl.builder.ImageTransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.runtime.api.Framework;

public class DynamicTransformationServiceImpl
implements DynamicTransformationService {
    @Override
    public Blob transform(DocumentModel doc, Transformation transformation) {
        if (doc.hasFacet("Picture")) {
            Blob blob = (Blob)doc.getPropertyValue("file:content");
            return this.transformPicture(blob, transformation, doc.getCoreSession());
        }
        if (doc.hasFacet("Video")) {
            VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
            return this.transformVideo(videoDocument.getVideo().getBlob(), transformation, doc.getCoreSession());
        }
        throw new NuxeoException(String.format("Document %s cannot be transformed", doc.getId()));
    }

    @Override
    public Blob transformPicture(Blob blob, Transformation transformation, CoreSession session) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder conversionResult = conversionService.convert("dynamicImageResizer", (BlobHolder)new SimpleBlobHolder(blob), transformation.toMap());
        Blob convertedBlob = conversionResult.getBlob();
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = registry.getMimetypeFromExtension(transformation.getFormat());
        convertedBlob.setFilename(this.getTargetFileName(blob, transformation));
        convertedBlob.setMimeType(mimetype);
        try {
            Blob watermarkBlob = this.getWatermarkBlob(transformation, session);
            if (watermarkBlob == null) {
                return convertedBlob;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("format", transformation.getFormat());
            params.put("gravity", "Center");
            params.put("watermarkFilePath", watermarkBlob.getCloseableFile().file.getPath());
            BlobHolder watermarkResult = conversionService.convert("composeGravityWatermarkedImage", (BlobHolder)new SimpleBlobHolder(convertedBlob), params);
            Blob watermarkedBlob = watermarkResult.getBlob();
            watermarkedBlob.setFilename(this.getTargetFileName(blob, transformation));
            watermarkedBlob.setMimeType(mimetype);
            return watermarkedBlob;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public Blob transformVideo(Blob blob, Transformation transformation, CoreSession session) {
        Map<String, Serializable> params = transformation.toMap();
        String converterName = "dynamicVideoTransform";
        try {
            Blob watermarkBlob = this.getWatermarkBlob(transformation, session);
            if (watermarkBlob != null) {
                converterName = "dynamicVideoTransformWithWatermark";
                params.put("watermarkFilePath", (Serializable)((Object)watermarkBlob.getCloseableFile().file.getPath()));
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder conversionResult = conversionService.convert(converterName, (BlobHolder)new SimpleBlobHolder(blob), params);
        Blob convertedBlob = conversionResult.getBlob();
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = registry.getMimetypeFromExtension(transformation.getFormat());
        convertedBlob.setFilename(this.getTargetFileName(blob, transformation));
        convertedBlob.setMimeType(mimetype);
        return convertedBlob;
    }

    public Blob getWatermarkBlob(Transformation transformation, CoreSession session) throws IOException {
        String converterName;
        Blob baseWatermark = this.getBaseWatermark(transformation, session);
        if (baseWatermark == null) {
            return null;
        }
        Blob canvas = this.getTransparentCanvas(transformation.getWidth(), transformation.getHeight());
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("watermarkFilePath", baseWatermark.getCloseableFile().file.getPath());
        String watermarkGravity = transformation.getWatermarkGravity();
        if ("tile".equals(watermarkGravity)) {
            converterName = "composeTileWatermarkedImage";
        } else {
            converterName = "composeGravityWatermarkedImage";
            params.put("gravity", transformation.getWatermarkGravity());
        }
        params.put("format", "png");
        BlobHolder watermarkHolder = conversionService.convert(converterName, (BlobHolder)new SimpleBlobHolder(canvas), params);
        return watermarkHolder.getBlob();
    }

    public Blob getWatermarkBlobFromText(Transformation transformation) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = conversionService.convert("text2WatermarkImage", (BlobHolder)new SimpleBlobHolder((Blob)new StringBlob(transformation.getTextWatermark())), transformation.toMap());
        return result.getBlob();
    }

    public Blob getWatermarkFromId(String watermarkId, Transformation transformation, CoreSession session) {
        DocumentModel watermarkDoc = session.getDocument((DocumentRef)new IdRef(watermarkId));
        long canvasWidth = transformation.getWidth();
        long watermarkWidth = Math.max(canvasWidth / 4L, 256L);
        Object watermarkTransformation = ((ImageTransformationBuilder)((ImageTransformationBuilder)new ImageTransformationBuilder(watermarkDoc).width(watermarkWidth)).format(Constants.PNG)).build();
        return this.transform(watermarkDoc, (Transformation)watermarkTransformation);
    }

    public String getTargetFileName(Blob blob, Transformation transformation) {
        String name = FilenameUtils.removeExtension((String)blob.getFilename());
        return String.format("%s_%dx%d.%s", name, transformation.getWidth(), transformation.getHeight(), transformation.getFormat());
    }

    public Blob getTransparentCanvas(long width, long height) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("color", "none");
        params.put("height", "" + height);
        params.put("width", "" + width);
        BlobHolder blobHolder = conversionService.convert("solidCanvasGenerator", (BlobHolder)new SimpleBlobHolder((Blob)new StringBlob("", "void")), params);
        return blobHolder.getBlob();
    }

    public Blob getBaseWatermark(Transformation transformation, CoreSession session) {
        Blob baseBlob = null;
        if (transformation.getImageWatermark() != null) {
            baseBlob = transformation.getImageWatermark();
        } else if (StringUtils.isNotBlank((CharSequence)transformation.getWatermarkId())) {
            baseBlob = this.getWatermarkFromId(transformation.getWatermarkId(), transformation, session);
        } else if (StringUtils.isNotBlank((CharSequence)transformation.getTextWatermark())) {
            baseBlob = this.getWatermarkBlobFromText(transformation);
        }
        return baseBlob;
    }
}

