/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.impl.builder.ImageTransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;

@Operation(id="Blob.ImageTransform", category="Document", label="Image Transformation", description="Perform image transformation such as crop, resize and format")
public class ImageTransformOp {
    public static final String ID = "Blob.ImageTransform";
    @Param(name="width", required=false)
    long width;
    @Param(name="height", required=false)
    long height;
    @Param(name="format", required=false)
    String format;
    @Param(name="crop", required=false)
    String crop;
    @Param(name="autoCropRatio", required=false)
    String autoCropRatio;
    @Param(name="textWatermark", required=false)
    String textWatermark;
    @Param(name="imageWatermark", required=false)
    Blob imageWatermark;
    @Param(name="watermarkId", required=false)
    String watermarkId;
    @Param(name="watermarkGravity", required=false)
    String watermarkGravity;
    @Param(name="colorSpace", required=false)
    String colorSpace;
    @Param(name="backgroundColor", required=false)
    String backgroundColor;
    @Param(name="compressionLevel", required=false)
    int compressionLevel;
    @Context
    DynamicTransformationService transformationService;
    @Context
    ImagingService imagingService;
    @Context
    CoreSession session;

    @OperationMethod
    public Blob run(DocumentModel document) {
        Object transformation = ((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)new ImageTransformationBuilder(document).width(this.width)).height(this.height)).cropBox(this.crop)).cropRatio(this.autoCropRatio)).format(this.format)).textWatermark(this.textWatermark)).imageWatermark(this.imageWatermark)).watermarkId(this.watermarkId)).watermarkGravity(this.watermarkGravity)).colorSpace(this.colorSpace)).backgroundColor(this.backgroundColor)).compressionLevel(this.compressionLevel)).build();
        return this.transformationService.transform(document, (Transformation)transformation);
    }

    @OperationMethod
    public Blob run(Blob blob) {
        ImageInfo info = this.imagingService.getImageInfo(blob);
        Object transformation = ((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)new ImageTransformationBuilder(info).width(this.width)).height(this.height)).cropBox(this.crop)).cropRatio(this.autoCropRatio)).format(this.format)).textWatermark(this.textWatermark)).imageWatermark(this.imageWatermark)).watermarkId(this.watermarkId)).watermarkGravity(this.watermarkGravity)).colorSpace(this.colorSpace)).backgroundColor(this.backgroundColor)).compressionLevel(this.compressionLevel)).build();
        return this.transformationService.transformPicture(blob, (Transformation)transformation, this.session);
    }
}

