/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

@Operation(id="Picture.AddView", category="Document", label="Add Picture View", description="Add an picture view to a document which holds the Picture Facet")
public class AddPictureViewOp {
    public static final String ID = "Picture.AddView";
    @Param(name="viewTitle", required=true)
    String title;
    @Param(name="viewDescription", required=true)
    String description;
    @Param(name="blob", required=true)
    Blob blob;
    @Param(name="save", required=false)
    boolean save = false;
    @Context
    CoreSession session;
    @Context
    ImagingService imagingService;

    @OperationMethod
    public DocumentModel run(DocumentModel document) {
        MultiviewPicture adapter = (MultiviewPicture)document.getAdapter(MultiviewPicture.class);
        ImageInfo imageInfo = this.imagingService.getImageInfo(this.blob);
        PictureViewImpl pictureView = new PictureViewImpl();
        pictureView.setTitle(this.title);
        pictureView.setDescription(this.description);
        pictureView.setBlob(this.blob);
        pictureView.setImageInfo(imageInfo);
        adapter.addView((PictureView)pictureView);
        if (this.save) {
            this.session.saveDocument(document);
        }
        return document;
    }
}

