/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.labs.asset.transformation.api.Transformation;
import org.nuxeo.labs.asset.transformation.impl.builder.ImageTransformationBuilder;
import org.nuxeo.labs.asset.transformation.service.DynamicTransformationService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/transform")
@WebObject(type="transform")
public class TransformObject
extends DefaultObject {
    public static final String DOWNLOAD_URL = "downloadUrl";

    @GET
    @Path(value="/{id}")
    public Object getTransform(@HeaderParam(value="accept") String acceptHeader, @PathParam(value="id") String documentId, @QueryParam(value="width") long width, @QueryParam(value="height") long height, @QueryParam(value="format") String format, @QueryParam(value="crop") String crop, @QueryParam(value="autoCropRatio") double autoCropRatio, @QueryParam(value="textWatermark") String textWatermark, @QueryParam(value="watermarkId") String watermarkId, @QueryParam(value="watermarkGravity") String watermarkGravity, @QueryParam(value="colorSpace") String colorSpace, @QueryParam(value="backgroundColor") String backgroundColor, @QueryParam(value="compressionLevel") int compressionLevel) {
        boolean acceptJson = false;
        if (StringUtils.isNotBlank((CharSequence)acceptHeader)) {
            List<String> types = Arrays.asList(acceptHeader.split(","));
            acceptJson = types.contains("application/json");
        }
        CoreSession session = this.getContext().getCoreSession();
        DocumentModel document = session.getDocument((DocumentRef)new IdRef(documentId));
        DynamicTransformationService service = (DynamicTransformationService)Framework.getService(DynamicTransformationService.class);
        Transformation transformation = ((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)((ImageTransformationBuilder)new ImageTransformationBuilder(document).width(width)).height(height)).cropBox(crop)).cropRatio(autoCropRatio)).format(format)).textWatermark(textWatermark)).watermarkId(watermarkId)).watermarkGravity(watermarkGravity)).colorSpace(colorSpace)).backgroundColor(backgroundColor)).compressionLevel(compressionLevel)).build();
        Blob result = service.transform(document, transformation);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String key = downloadService.storeBlobs(List.of(result));
        String downloadPath = downloadService.getDownloadUrl(key);
        String baseUrl = Framework.getProperty((String)"nuxeo.url");
        String fullUrl = String.format("%s/%s", baseUrl, downloadPath);
        if (acceptJson) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(DOWNLOAD_URL, (Object)fullUrl);
            return new StringBlob(jsonObject.toString(), "application/json");
        }
        return Response.status((int)302).location(URI.create(fullUrl)).build();
    }
}

