/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.asset.transformation.converter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineConverter;

public class Text2WatermarkImageConverter
extends CommandLineConverter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String text = (String)((Object)parameters.get("textWatermark"));
        int imageWidth = Integer.parseInt((String)((Object)parameters.get("width")));
        int watermarkMaxRepeat = Integer.parseInt(this.initParameters.getOrDefault("watermarkMaxRepeat", "4"));
        int watermarkMinRepeatWidthInPx = Integer.parseInt(this.initParameters.getOrDefault("watermarkMinRepeatWidthInPx", "256"));
        int watermarkWidth = imageWidth / watermarkMinRepeatWidthInPx > watermarkMaxRepeat ? imageWidth / watermarkMaxRepeat : (imageWidth / watermarkMinRepeatWidthInPx < 1 ? imageWidth : watermarkMinRepeatWidthInPx);
        int pointSize = Math.max(watermarkWidth / text.length(), 1);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("textWatermark", text);
        params.put("color", parameters.getOrDefault("textColor", (Serializable)((Object)this.initParameters.getOrDefault("textColor", "graya(50%, 0.8)"))));
        params.put("pointSize", "" + pointSize);
        params.put("width", "" + watermarkWidth);
        params.put("height", "" + watermarkWidth);
        return super.convert(blobHolder, params);
    }
}

