/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchLocalConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;
import org.nuxeo.elasticsearch.nxql.NxqlQueryConverter;
import org.nuxeo.elasticsearch.work.IndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ElasticSearchComponent
extends DefaultComponent
implements ElasticSearchService,
ElasticSearchIndexing,
ElasticSearchAdmin {
    private static final Log log = LogFactory.getLog(ElasticSearchComponent.class);
    public static final String EP_REMOTE = "elasticSearchRemote";
    public static final String EP_LOCAL = "elasticSearchLocal";
    public static final String EP_INDEX = "elasticSearchIndex";
    public static final String ID_FIELD = "_id";
    protected Node localNode;
    protected Client client;
    protected boolean indexInitDone = false;
    protected List<IndexingCommand> stackedCommands = new ArrayList<IndexingCommand>();
    protected final CopyOnWriteArrayList<String> pendingWork = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<String> pendingCommands = new CopyOnWriteArrayList();
    protected Map<String, ElasticSearchIndexConfig> indexes = new HashMap<String, ElasticSearchIndexConfig>();
    protected List<String> fulltextFields;
    protected String docIndexName;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected Timer searchTimer;
    protected Timer fetchTimer;
    private ElasticSearchLocalConfig localConfig;
    private ElasticSearchRemoteConfig remoteConfig;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EP_LOCAL.equals(extensionPoint)) {
            this.release();
            this.localConfig = (ElasticSearchLocalConfig)contribution;
            this.remoteConfig = null;
        } else if (EP_REMOTE.equals(extensionPoint)) {
            this.release();
            this.remoteConfig = (ElasticSearchRemoteConfig)contribution;
            this.localConfig = null;
        } else if (EP_INDEX.equals(extensionPoint)) {
            ElasticSearchIndexConfig idx = (ElasticSearchIndexConfig)contribution;
            ElasticSearchIndexConfig previous = this.indexes.put(idx.getType(), idx);
            idx.merge(previous);
            if ("doc".equals(idx.getType())) {
                this.docIndexName = idx.getName();
            }
        }
    }

    public ElasticSearchLocalConfig getLocalConfig() {
        if (Framework.isTestModeSet() && this.localConfig == null && this.remoteConfig == null) {
            this.localConfig = new ElasticSearchLocalConfig();
            this.localConfig.setHttpEnabled(true);
            this.localConfig.setIndexStorageType("memory");
            this.localConfig.setNodeName("nuxeoTestNode");
            this.localConfig.setClusterName("nuxeoTestCluster-" + RandomStringUtils.randomAlphanumeric((int)6));
            this.remoteConfig = null;
        }
        return this.localConfig;
    }

    protected void schedulePostCommitIndexing(IndexingCommand cmd) throws ClientException {
        try {
            EventProducer evtProducer = (EventProducer)Framework.getLocalService(EventProducer.class);
            Event indexingEvent = cmd.asIndexingEvent();
            evtProducer.fireEvent(indexingEvent);
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    @Override
    public void indexNow(List<IndexingCommand> cmds) throws ClientException {
        if (!this.indexInitDone) {
            this.stackedCommands.addAll(cmds);
            log.debug((Object)"Delaying indexing request : waiting for Index to be initialized");
            return;
        }
        BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
        for (IndexingCommand cmd : cmds) {
            if ("ESUnIndex".equals(cmd.getName())) {
                this.indexNow(cmd);
                continue;
            }
            log.debug((Object)("Sending bulk indexing request to ElasticSearch " + cmd.toString()));
            IndexRequestBuilder idxRequest = this.buildESIndexingRequest(cmd);
            bulkRequest.add(idxRequest);
        }
        if (bulkRequest.numberOfActions() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Index bulk request: curl -XPOST 'http://localhost:9200/_bulk' -d '%s'", ((BulkRequest)bulkRequest.request()).requests().toString()));
            }
            bulkRequest.execute().actionGet();
        }
        for (IndexingCommand cmd : cmds) {
            this.markCommandExecuted(cmd);
        }
    }

    @Override
    public void indexNow(IndexingCommand cmd) throws ClientException {
        if (!this.indexInitDone) {
            this.stackedCommands.add(cmd);
            log.debug((Object)"Delaying indexing request : waiting for Index to be initialized");
            return;
        }
        DocumentModel doc = cmd.getTargetDocument();
        if (doc == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending indexing request to ElasticSearch " + cmd.toString()));
        }
        if ("ESUnIndex".equals(cmd.getName())) {
            DeleteRequestBuilder request = this.getClient().prepareDelete(this.getDocIndex(), "doc", doc.getId());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Delete request: curl -XDELETE 'http://localhost:9200/%s/%s/%s' -d '%s'", this.getDocIndex(), "doc", doc.getId(), ((DeleteRequest)request.request()).toString()));
            }
            request.execute().actionGet();
            if (cmd.isRecurse()) {
                DeleteByQueryRequestBuilder deleteRequest = this.getClient().prepareDeleteByQuery(new String[]{this.getDocIndex()}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((FilterBuilder)FilterBuilders.termFilter((String)"ecm:path.children", (String)doc.getPathAsString())));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Delete byQuery request: curl -XDELETE 'http://localhost:9200/%s/%s/_query' -d '%s'", this.getDocIndex(), "doc", ((DeleteRequest)request.request()).toString()));
                }
                deleteRequest.execute().actionGet();
            }
        } else {
            IndexRequestBuilder request = this.buildESIndexingRequest(cmd);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Index request: curl -XPUT 'http://localhost:9200/%s/%s/%s' -d '%s'", this.getDocIndex(), "doc", doc.getId(), ((IndexRequest)request.request()).toString()));
            }
            request.execute().actionGet();
        }
        this.markCommandExecuted(cmd);
    }

    protected String getDocIndex() {
        return this.docIndexName;
    }

    protected IndexRequestBuilder buildESIndexingRequest(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        try {
            JsonFactory factory = new JsonFactory();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            JsonGenerator jsonGen = factory.createJsonGenerator(builder.stream());
            JsonESDocumentWriter.writeESDocument((JsonGenerator)jsonGen, (DocumentModel)doc, (String[])cmd.getSchemas(), null);
            return this.getClient().prepareIndex(this.getDocIndex(), "doc", doc.getId()).setSource(builder);
        }
        catch (Exception e) {
            throw new ClientException("Unable to create index request for Document " + doc.getId(), (Throwable)e);
        }
    }

    protected void markCommandExecuted(IndexingCommand cmd) {
        this.pendingWork.remove(this.getWorkKey(cmd.getTargetDocument()));
        this.pendingCommands.remove(cmd.getId());
    }

    @Override
    public void scheduleIndexing(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        if (doc == null) {
            return;
        }
        boolean added = this.pendingCommands.addIfAbsent(cmd.getId());
        if (!added) {
            log.debug((Object)("Skip indexing for " + doc + " since it is already scheduled"));
            return;
        }
        added = this.pendingWork.addIfAbsent(this.getWorkKey(doc));
        if (!added) {
            log.debug((Object)("Skip indexing for " + doc + " since it is already scheduled"));
            return;
        }
        if (cmd.isSync()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schedule PostCommit indexing request " + cmd.toString()));
            }
            this.schedulePostCommitIndexing(cmd);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schedule Async indexing request  " + cmd.toString()));
            }
            WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
            IndexingWorker idxWork = new IndexingWorker(cmd);
            wm.schedule((Work)idxWork, true);
        }
    }

    @Override
    public void refresh() {
        this.getClient().admin().indices().prepareRefresh(new String[]{this.getDocIndex()}).execute().actionGet();
    }

    @Override
    public void flush() {
        this.getClient().admin().indices().prepareFlush(new String[]{this.getDocIndex()}).execute().actionGet();
    }

    @Override
    public Client getClient() {
        if (this.client == null) {
            ElasticSearchLocalConfig lConf = this.getLocalConfig();
            if (lConf != null) {
                log.info((Object)"Creating a local ES node inJVM");
                ImmutableSettings.Builder sBuilder = ImmutableSettings.settingsBuilder();
                sBuilder.put("http.enabled", lConf.httpEnabled()).put("path.logs", lConf.getLogPath()).put("path.data", lConf.getDataPath()).put("index.number_of_shards", 1).put("index.number_of_replicas", 1).put("cluster.name", lConf.getClusterName()).put("node.name", lConf.getNodeName());
                if (lConf.getIndexStorageType() != null) {
                    sBuilder.put("index.store.type", lConf.getIndexStorageType());
                    if (lConf.getIndexStorageType().equals("memory")) {
                        sBuilder.put("gateway.type", "none");
                    }
                }
                Settings settings = sBuilder.build();
                log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
                this.localNode = NodeBuilder.nodeBuilder().local(true).settings(settings).node();
                this.client = this.localNode.start().client();
            } else if (this.remoteConfig != null) {
                log.info((Object)"Connecting to an ES cluster");
                ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("cluster.name", this.remoteConfig.getClusterName()).put("client.transport.nodes_sampler_interval", this.remoteConfig.getSamplerInterval()).put("index.number_of_shards", this.remoteConfig.getNumberOfShards()).put("index.number_of_replicas", this.remoteConfig.getNumberOfReplicas()).put("client.transport.ping_timeout", this.remoteConfig.getPingTimeout()).put("client.transport.ignore_cluster_name", this.remoteConfig.isIgnoreClusterName()).put("client.transport.sniff", this.remoteConfig.isClusterSniff());
                Settings settings = builder.build();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
                }
                TransportClient tClient = new TransportClient(settings);
                String[] addresses = this.remoteConfig.getAddresses();
                if (addresses == null) {
                    log.error((Object)"You need to provide an addressList to join a cluster");
                } else {
                    for (String item : this.remoteConfig.getAddresses()) {
                        String[] address = item.split(":");
                        log.info((Object)("Add transport address: " + item));
                        try {
                            InetAddress inet = InetAddress.getByName(address[0]);
                            tClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(inet, Integer.parseInt(address[1])));
                        }
                        catch (UnknownHostException e) {
                            log.error((Object)("Unable to resolve host " + address[0]), (Throwable)e);
                        }
                    }
                }
                this.client = tClient;
            }
            if (this.client != null) {
                try {
                    this.client.admin().indices().status(new IndicesStatusRequest()).get();
                }
                catch (InterruptedException | ExecutionException | NoNodeAvailableException e) {
                    log.error((Object)("Failed to connect to elasticsearch: " + e.getMessage()), e);
                    this.client = null;
                }
            }
        }
        return this.client;
    }

    @Override
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        QueryBuilder queryBuilder = NxqlQueryConverter.toESQueryBuilder(nxql);
        if (nxql.toLowerCase().contains("order by")) {
            List<SortInfo> builtInSortInfos = NxqlQueryConverter.getSortInfo(nxql);
            if (sortInfos != null) {
                for (SortInfo si : sortInfos) {
                    builtInSortInfos.add(si);
                }
            }
            sortInfos = builtInSortInfos.toArray(new SortInfo[builtInSortInfos.size()]);
        }
        return this.query(session, queryBuilder, limit, offset, sortInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        long totalSize;
        ArrayList<String> ids;
        Timer.Context stopWatch = this.searchTimer.time();
        try {
            SearchRequestBuilder request = this.getClient().prepareSearch(new String[]{this.getDocIndex()}).setTypes(new String[]{"doc"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addField(ID_FIELD).setFrom(offset).setSize(limit);
            AndFilterBuilder aclFilter = null;
            Principal principal = session.getPrincipal();
            if (!(principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator())) {
                String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
                aclFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.inFilter((String)"ecm:acl", (String[])principals), FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)"ecm:acl", (String[])new String[]{"_UNSUPPORTED_ACL_"}))});
            }
            if (aclFilter == null) {
                request.setQuery(queryBuilder);
            } else {
                request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, aclFilter));
            }
            if (sortInfos != null) {
                for (SortInfo sortInfo : sortInfos) {
                    request.addSort(sortInfo.getSortColumn(), sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty' -d '%s'", this.getDocIndex(), "doc", request.toString()));
            }
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response: " + response.toString()));
            }
            ids = new ArrayList<String>(limit);
            for (SearchHit hit : response.getHits()) {
                ids.add(hit.getId());
            }
            totalSize = response.getHits().getTotalHits();
        }
        finally {
            stopWatch.stop();
        }
        DocumentModelListImpl ret = new DocumentModelListImpl(ids.size());
        stopWatch = this.fetchTimer.time();
        try {
            ret.setTotalSize(totalSize);
            if (!ids.isEmpty()) {
                try {
                    ret.addAll(this.fetchDocuments(ids, session));
                }
                catch (ClientException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            stopWatch.stop();
        }
        return ret;
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        super.applicationStarted(context);
        if (this.remoteConfig == null && this.getLocalConfig() == null) {
            log.warn((Object)"Unable to initialize Elasticsearch service : no configuration is provided");
            return;
        }
        this.searchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "search"}));
        this.fetchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "fetch"}));
        this.getClient();
        this.initIndexes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initIndexes(boolean dropIfExists) {
        for (ElasticSearchIndexConfig idx : this.indexes.values()) {
            this.initIndex(idx, dropIfExists);
        }
        this.indexInitDone = true;
        if (!this.stackedCommands.isEmpty()) {
            log.info((Object)"Processing indexing command stacked during startup");
            boolean txCreated = false;
            if (!TransactionHelper.isTransactionActive()) {
                txCreated = TransactionHelper.startTransaction();
            }
            try {
                for (final IndexingCommand cmd : this.stackedCommands) {
                    new UnrestrictedSessionRunner(cmd.getRepository()){

                        public void run() throws ClientException {
                            cmd.refresh(this.session);
                            ElasticSearchComponent.this.indexNow(cmd);
                        }
                    }.runUnrestricted();
                }
            }
            catch (Exception e) {
                log.error((Object)("Unable to flush pending indexing commands: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (txCreated) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
                this.stackedCommands.clear();
                log.debug((Object)"Done");
            }
        }
    }

    protected void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        if (!conf.mustCreate()) {
            return;
        }
        log.info((Object)String.format("Initialize index: %s, type: %s", conf.getName(), conf.getType()));
        boolean mappingExists = false;
        boolean indexExists = ((IndicesExistsResponse)this.getClient().admin().indices().prepareExists(new String[]{conf.getName()}).execute().actionGet()).isExists();
        if (indexExists) {
            if (!dropIfExists) {
                log.debug((Object)("Index " + conf.getName() + " already exists"));
                mappingExists = ((GetMappingsResponse)this.getClient().admin().indices().prepareGetMappings(new String[]{conf.getName()}).execute().actionGet()).getMappings().containsKey((Object)"doc");
            } else {
                log.warn((Object)String.format("Initializing index: %s, type: %s with dropIfExists flag, deleting an existing index", conf.getName(), conf.getType()));
                this.getClient().admin().indices().delete(new DeleteIndexRequest(conf.getName())).actionGet();
                indexExists = false;
            }
        }
        if (!indexExists) {
            log.info((Object)String.format("Creating index: %s", conf.getName()));
            this.getClient().admin().indices().prepareCreate(conf.getName()).setSettings(conf.getSettings()).execute().actionGet();
        }
        if (!mappingExists) {
            log.info((Object)String.format("Creating mapping type: %s on index: %s", conf.getType(), conf.getName()));
            this.getClient().admin().indices().preparePutMapping(new String[]{conf.getName()}).setType(conf.getType()).setSource(conf.getMapping()).execute().actionGet();
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.release();
    }

    protected void release() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.localNode != null) {
            log.info((Object)"Shutting down local node");
            this.localNode.stop();
            this.localNode.close();
        }
        this.client = null;
        this.localNode = null;
    }

    protected String getWorkKey(DocumentModel doc) {
        return doc.getRepositoryName() + ":" + doc.getId();
    }

    @Override
    public boolean isAlreadyScheduledForIndexing(DocumentModel doc) {
        return this.pendingWork.contains(this.getWorkKey(doc));
    }

    @Override
    public int getPendingDocs() {
        return this.pendingWork.size();
    }

    @Override
    public int getPendingCommands() {
        return this.pendingCommands.size();
    }

    @Override
    public List<PendingClusterTask> getPendingTasks() {
        PendingClusterTasksResponse response = (PendingClusterTasksResponse)this.getClient().admin().cluster().preparePendingClusterTasks().execute().actionGet();
        return response.getPendingTasks();
    }

    protected List<DocumentModel> fetchDocuments(final List<String> ids, CoreSession session) throws ClientException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document WHERE ecm:uuid IN (");
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(NXQL.escapeString((String)ids.get(i)));
            if (i >= ids.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        DocumentModelList ret = session.query(sb.toString());
        Collections.sort(ret, new Comparator<DocumentModel>(){

            @Override
            public int compare(DocumentModel a, DocumentModel b) {
                return ids.indexOf(a.getId()) - ids.indexOf(b.getId());
            }
        });
        return ret;
    }
}

