/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;

public class IndexingCommand {
    public static final String INDEX = "ESIndex";
    public static final String UPDATE = "ESReIndex";
    public static final String UPDATE_SECURITY = "ESReIndexSecurity";
    public static final String DELETE = "ESUnIndex";
    protected String name;
    protected boolean sync;
    protected boolean recurse;
    protected DocumentModel targetDocument;
    protected String uid;
    protected String path;
    protected String repository;
    protected String id;
    protected static final Log log = LogFactory.getLog(IndexingCommand.class);
    public static final String PREFIX = "IndexingCommand-";
    protected List<String> schemas;
    protected transient Event indexingEvent;

    protected IndexingCommand() {
    }

    public IndexingCommand(DocumentModel targetDocument, String command, boolean sync, boolean recurse) {
        this.id = PREFIX + UUID.randomUUID().toString();
        this.name = command;
        this.sync = sync;
        this.recurse = recurse;
        this.targetDocument = targetDocument;
        this.markUpdated();
    }

    public IndexingCommand(DocumentModel targetDocument, boolean sync, boolean recurse) {
        this(targetDocument, INDEX, sync, recurse);
    }

    public void refresh(CoreSession session) throws ClientException {
        if (session.exists(this.targetDocument.getRef())) {
            this.targetDocument = session.getDocument(this.targetDocument.getRef());
        }
        this.markUpdated();
    }

    public String getRepository() {
        if (this.repository != null) {
            return this.repository;
        }
        if (this.targetDocument != null) {
            return this.targetDocument.getRepositoryName();
        }
        return null;
    }

    public void update(IndexingCommand other) {
        this.update(other.sync, other.recurse);
    }

    public void update(boolean sync, boolean recurse) {
        this.sync = this.sync || sync;
        this.recurse = this.recurse || recurse;
        this.markUpdated();
    }

    public boolean isSync() {
        return this.sync;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public String getName() {
        return this.name;
    }

    public DocumentModel getTargetDocument() {
        return this.targetDocument;
    }

    public String toJSON() throws IOException {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        JsonGenerator jsonGen = factory.createJsonGenerator((Writer)out);
        this.toJSON(jsonGen);
        out.flush();
        jsonGen.close();
        return out.toString();
    }

    public void toJSON(JsonGenerator jsonGen) throws IOException {
        jsonGen.writeStartObject();
        jsonGen.writeStringField("id", this.id);
        jsonGen.writeStringField("name", this.name);
        jsonGen.writeStringField("docId", this.targetDocument.getId());
        jsonGen.writeStringField("path", this.targetDocument.getPathAsString());
        jsonGen.writeStringField("repo", this.targetDocument.getRepositoryName());
        jsonGen.writeBooleanField("recurse", this.recurse);
        jsonGen.writeBooleanField("sync", this.sync);
        jsonGen.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexingCommand fromJSON(CoreSession session, String json) throws ClientException {
        IndexingCommand indexingCommand;
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jp = jsonFactory.createJsonParser(json);
        try {
            indexingCommand = IndexingCommand.fromJSON(session, jp);
        }
        catch (Throwable throwable) {
            try {
                jp.close();
                throw throwable;
            }
            catch (Exception e) {
                throw ClientException.wrap((Throwable)e);
            }
        }
        jp.close();
        return indexingCommand;
    }

    public static IndexingCommand fromJSON(CoreSession session, JsonParser jp) throws Exception {
        IndexingCommand cmd = new IndexingCommand();
        JsonToken token = jp.nextToken();
        if (token != JsonToken.START_OBJECT) {
            return null;
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("name".equals(fieldname)) {
                cmd.name = jp.getText();
                continue;
            }
            if ("docId".equals(fieldname)) {
                cmd.uid = jp.getText();
                continue;
            }
            if ("path".equals(fieldname)) {
                cmd.path = jp.getText();
                continue;
            }
            if ("repo".equals(fieldname)) {
                cmd.repository = jp.getText();
                continue;
            }
            if ("id".equals(fieldname)) {
                cmd.id = jp.getText();
                continue;
            }
            if ("recurse".equals(fieldname)) {
                cmd.recurse = jp.getBooleanValue();
                continue;
            }
            if (!"sync".equals(fieldname)) continue;
            cmd.recurse = jp.getBooleanValue();
        }
        if (cmd.uid != null) {
            if (!session.getRepositoryName().equals(cmd.repository)) {
                log.error((Object)("Unable to restore doc from repository " + cmd.repository + " with a session on repository " + session.getRepositoryName()));
            } else {
                IdRef ref = new IdRef(cmd.uid);
                if (!session.exists((DocumentRef)ref)) {
                    if (!DELETE.equals(cmd.getName())) {
                        log.warn((Object)("Unable to restieve document " + cmd.uid + " form indexing command " + cmd.name));
                    }
                } else {
                    cmd.targetDocument = session.getDocument((DocumentRef)ref);
                }
            }
        }
        return cmd;
    }

    public String getId() {
        return this.id;
    }

    public IndexingCommand clone(DocumentModel newDoc) {
        return new IndexingCommand(newDoc, this.name, this.sync, this.recurse);
    }

    public String[] getSchemas() {
        if (this.schemas == null || this.schemas.size() == 0) {
            return this.targetDocument.getSchemas();
        }
        return this.schemas.toArray(new String[this.schemas.size()]);
    }

    public void addSchemas(String schema) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>();
        }
        if (!this.schemas.contains(schema)) {
            this.schemas.add(schema);
        }
        this.markUpdated();
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public void computeIndexingEvent() throws IOException {
        if (this.getTargetDocument() != null) {
            CoreSession session = this.getTargetDocument().getCoreSession();
            if (session != null) {
                EventContextImpl context = new EventContextImpl(session, session.getPrincipal());
                this.indexingEvent = context.newEvent("ESIndexSyncTrigger");
            } else {
                log.error((Object)("Unable to generate event from cmd " + this.toString()));
            }
        }
    }

    public Event asIndexingEvent() throws IOException {
        if (this.indexingEvent == null) {
            this.computeIndexingEvent();
        }
        if (this.indexingEvent != null) {
            this.indexingEvent.getContext().getProperties().put(this.getId(), this.toJSON());
        }
        return this.indexingEvent;
    }

    protected void markUpdated() {
        this.indexingEvent = null;
        if (this.sync) {
            try {
                this.computeIndexingEvent();
            }
            catch (IOException e) {
                log.error((Object)"Unable to build event from Command", (Throwable)e);
            }
        }
    }
}

