/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.commands.IndexingCommands;
import org.nuxeo.elasticsearch.commands.IndexingCommandsStacker;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchInlineListener
extends IndexingCommandsStacker
implements EventListener,
Synchronization {
    private static final Log log = LogFactory.getLog(ElasticSearchInlineListener.class);
    protected static boolean useTxSync = true;
    protected static ThreadLocal<Map<String, IndexingCommands>> transactionCommands = new ThreadLocal<Map<String, IndexingCommands>>(){

        @Override
        protected HashMap<String, IndexingCommands> initialValue() {
            return new HashMap<String, IndexingCommands>();
        }
    };
    protected static ThreadLocal<Boolean> synched = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    public static ThreadLocal<Boolean> useSyncIndexing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        @Override
        public void set(Boolean value) {
            super.set(value);
            if (Boolean.TRUE.equals(value)) {
                for (IndexingCommands cmds : transactionCommands.get().values()) {
                    for (IndexingCommand cmd : cmds.getAllCommands()) {
                        if (cmd.isRecurse() || cmd.getTargetDocument() == null) continue;
                        cmd.update(true, cmd.isRecurse());
                    }
                }
            }
        }
    };

    @Override
    protected Map<String, IndexingCommands> getAllCommands() {
        return transactionCommands.get();
    }

    public void handleEvent(Event event) throws ClientException {
        String eventId = event.getName();
        if (event.isCommitEvent()) {
            if (!synched.get().booleanValue()) {
                this.flushCommands();
            }
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        this.stackCommand(docCtx, eventId);
        if (!synched.get().booleanValue() && useTxSync) {
            synched.set(this.registerSynchronization(this));
        }
    }

    protected void stackCommand(DocumentEventContext docCtx, String eventId) {
        if (Framework.isTestModeSet() && Framework.getRuntime().isShuttingDown()) {
            return;
        }
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc == null) {
            return;
        }
        Boolean block = (Boolean)docCtx.getProperty("disableAutoIndexing");
        if (block != null && block.booleanValue()) {
            log.debug((Object)("Skip indexing for doc " + docCtx.getSourceDocument()));
            return;
        }
        Boolean sync = (Boolean)docCtx.getProperty("ESSyncIndexing");
        if (sync == null) {
            sync = (Boolean)doc.getContextData().get((Object)"ESSyncIndexing");
        }
        if (sync == null && (sync = useSyncIndexing.get()) == null) {
            sync = false;
        }
        this.stackCommand(doc, eventId, sync);
    }

    @Override
    protected void fireSyncIndexing(List<IndexingCommand> syncCommands) throws ClientException {
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
        for (IndexingCommand cmd : syncCommands) {
            esi.scheduleIndexing(cmd);
        }
    }

    @Override
    protected void fireAsyncIndexing(List<IndexingCommand> asyncCommands) throws ClientException {
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
        for (IndexingCommand cmd : asyncCommands) {
            esi.scheduleIndexing(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        try {
            this.flushCommands();
        }
        catch (Exception e) {
            log.error((Object)"Error during flush", (Throwable)e);
        }
        finally {
            synched.set(false);
        }
    }

    public void afterCompletion(int status) {
        if (1 == status || 4 == status) {
            synched.set(false);
            this.getAllCommands().clear();
        }
        useSyncIndexing.set(null);
    }
}

