/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.provider.ElasticSearchQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchNativePageProvider
extends AbstractPageProvider<DocumentModel> {
    private static final long serialVersionUID = 1L;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    protected static final Log log = LogFactory.getLog(ElasticSearchNativePageProvider.class);
    protected List<DocumentModel> currentPageDocuments;

    public List<DocumentModel> getCurrentPage() {
        if (this.currentPageDocuments != null) {
            return this.currentPageDocuments;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Perform query for provider '%s': with pageSize=%d, offset=%d", this.getName(), this.getMinMaxPageSize(), this.getCurrentPageOffset()));
        }
        QueryBuilder query = this.makeQueryBuilder();
        SortInfo[] sortArray = null;
        if (this.sortInfos != null) {
            sortArray = this.sortInfos.toArray(new SortInfo[0]);
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getLocalService(ElasticSearchService.class);
        try {
            DocumentModelList dmList = ess.query(this.getCoreSession(), query, (int)this.getMinMaxPageSize(), (int)this.getCurrentPageOffset(), sortArray);
            this.setResultsCount(dmList.totalSize());
            this.currentPageDocuments = dmList;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return this.currentPageDocuments;
    }

    protected QueryBuilder makeQueryBuilder() {
        QueryBuilder ret = null;
        try {
            PageProviderDefinition def = this.getDefinition();
            if (def.getWhereClause() == null) {
                ret = ElasticSearchQueryBuilder.makeQuery(def.getPattern(), this.getParameters(), def.getQuotePatternParameters(), def.getEscapePatternParameters(), this.isNativeQuery());
            } else {
                DocumentModel searchDocumentModel = this.getSearchDocumentModel();
                if (searchDocumentModel == null) {
                    throw new ClientException(String.format("Cannot build query of provider '%s': no search document model is set", this.getName()));
                }
                ret = ElasticSearchQueryBuilder.makeQuery(searchDocumentModel, def.getWhereClause(), this.getParameters(), this.isNativeQuery());
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return ret;
    }

    protected void pageChanged() {
        this.currentPageDocuments = null;
        super.pageChanged();
    }

    public void refresh() {
        this.currentPageDocuments = null;
        super.refresh();
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }

    public boolean isNativeQuery() {
        return true;
    }
}

