/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class NodesOperationRequest<T extends NodesOperationRequest>
extends ActionRequest<T> {
    public static String[] ALL_NODES = Strings.EMPTY_ARRAY;
    private String[] nodesIds;
    private TimeValue timeout;

    protected NodesOperationRequest() {
    }

    protected NodesOperationRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    public final String[] nodesIds() {
        return this.nodesIds;
    }

    public final T nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return (T)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final T timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public final T timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, null);
        return (T)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodesIds = in.readStringArray();
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.nodesIds);
        if (this.timeout == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        }
    }
}

