/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.discovery.zen.fd.MasterFaultDetection;
import org.elasticsearch.discovery.zen.fd.NodesFaultDetection;
import org.elasticsearch.discovery.zen.membership.MembershipAction;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.publish.PublishClusterStateAction;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ZenDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery,
DiscoveryNodesProvider {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private AllocationService allocationService;
    private final ClusterName clusterName;
    private final DiscoveryNodeService discoveryNodeService;
    private final ZenPingService pingService;
    private final MasterFaultDetection masterFD;
    private final NodesFaultDetection nodesFD;
    private final PublishClusterStateAction publishClusterState;
    private final MembershipAction membership;
    private final Version version;
    private final TimeValue pingTimeout;
    private final boolean sendLeaveRequest;
    private final ElectMasterService electMaster;
    private final boolean masterElectionFilterClientNodes;
    private final boolean masterElectionFilterDataNodes;
    private DiscoveryNode localNode;
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    private volatile boolean master = false;
    private volatile DiscoveryNodes latestDiscoNodes;
    private volatile Thread currentJoinThread;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();
    @Nullable
    private NodeService nodeService;
    private final BlockingQueue<ProcessClusterState> processNewClusterStates = ConcurrentCollections.newBlockingQueue();

    @Inject
    public ZenDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, NodeSettingsService nodeSettingsService, DiscoveryNodeService discoveryNodeService, ZenPingService pingService, Version version, DiscoverySettings discoverySettings) {
        super(settings);
        this.clusterName = clusterName;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.discoveryNodeService = discoveryNodeService;
        this.pingService = pingService;
        this.version = version;
        this.pingTimeout = settings.getAsTime("discovery.zen.ping.timeout", settings.getAsTime("discovery.zen.ping_timeout", this.componentSettings.getAsTime("ping_timeout", this.componentSettings.getAsTime("initial_ping_timeout", TimeValue.timeValueSeconds(3L)))));
        this.sendLeaveRequest = this.componentSettings.getAsBoolean("send_leave_request", (Boolean)true);
        this.masterElectionFilterClientNodes = settings.getAsBoolean("discovery.zen.master_election.filter_client", (Boolean)true);
        this.masterElectionFilterDataNodes = settings.getAsBoolean("discovery.zen.master_election.filter_data", (Boolean)false);
        this.logger.debug("using ping.timeout [{}], master_election.filter_client [{}], master_election.filter_data [{}]", this.pingTimeout, this.masterElectionFilterClientNodes, this.masterElectionFilterDataNodes);
        this.electMaster = new ElectMasterService(settings);
        nodeSettingsService.addListener(new ApplySettings());
        this.masterFD = new MasterFaultDetection(settings, threadPool, transportService, this);
        this.masterFD.addListener(new MasterNodeFailureListener());
        this.nodesFD = new NodesFaultDetection(settings, threadPool, transportService);
        this.nodesFD.addListener(new NodeFailureListener());
        this.publishClusterState = new PublishClusterStateAction(settings, transportService, this, new NewClusterStateListener(), discoverySettings);
        this.pingService.setNodesProvider(this);
        this.membership = new MembershipAction(settings, transportService, this, new MembershipListener());
        transportService.registerHandler("discovery/zen/rejoin", new RejoinClusterRequestHandler());
    }

    @Override
    public void setNodeService(@Nullable NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setAllocationService(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        Map<String, String> nodeAttributes = this.discoveryNodeService.buildAttributes();
        String nodeId = DiscoveryService.generateNodeId(this.settings);
        this.localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), nodeAttributes, this.version);
        this.latestDiscoNodes = new DiscoveryNodes.Builder().put(this.localNode).localNodeId(this.localNode.id()).build();
        this.nodesFD.updateNodes(this.latestDiscoNodes);
        this.pingService.start();
        this.asyncJoinCluster();
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        this.pingService.stop();
        this.masterFD.stop("zen disco stop");
        this.nodesFD.stop();
        this.initialStateSent.set(false);
        if (this.sendLeaveRequest) {
            if (!this.master && this.latestDiscoNodes.masterNode() != null) {
                try {
                    this.membership.sendLeaveRequestBlocking(this.latestDiscoNodes.masterNode(), this.localNode, TimeValue.timeValueSeconds(1L));
                }
                catch (Exception e) {
                    this.logger.debug("failed to send leave request to master [{}]", e, this.latestDiscoNodes.masterNode());
                }
            } else {
                DiscoveryNode[] possibleMasters;
                for (DiscoveryNode possibleMaster : possibleMasters = this.electMaster.nextPossibleMasters(this.latestDiscoNodes.nodes().values(), 5)) {
                    if (this.localNode.equals(possibleMaster)) continue;
                    try {
                        this.membership.sendLeaveRequest(this.latestDiscoNodes.masterNode(), possibleMaster);
                    }
                    catch (Exception e) {
                        this.logger.debug("failed to send leave request from master [{}] to possible master [{}]", e, this.latestDiscoNodes.masterNode(), possibleMaster);
                    }
                }
            }
        }
        this.master = false;
        if (this.currentJoinThread != null) {
            try {
                this.currentJoinThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.masterFD.close();
        this.nodesFD.close();
        this.publishClusterState.close();
        this.membership.close();
        this.pingService.close();
    }

    @Override
    public DiscoveryNode localNode() {
        return this.localNode;
    }

    @Override
    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    @Override
    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode.id();
    }

    @Override
    public DiscoveryNodes nodes() {
        DiscoveryNodes latestNodes = this.latestDiscoNodes;
        if (latestNodes != null) {
            return latestNodes;
        }
        return DiscoveryNodes.builder().put(this.localNode).localNodeId(this.localNode.id()).build();
    }

    @Override
    public NodeService nodeService() {
        return this.nodeService;
    }

    @Override
    public void publish(ClusterState clusterState, Discovery.AckListener ackListener) {
        if (!this.master) {
            throw new ElasticsearchIllegalStateException("Shouldn't publish state when not master");
        }
        this.latestDiscoNodes = clusterState.nodes();
        this.nodesFD.updateNodes(clusterState.nodes());
        this.publishClusterState.publish(clusterState, ackListener);
    }

    private void asyncJoinCluster() {
        if (this.currentJoinThread != null) {
            this.logger.trace("a join thread already running", new Object[0]);
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ZenDiscovery.this.currentJoinThread = Thread.currentThread();
                try {
                    ZenDiscovery.this.innerJoinCluster();
                }
                finally {
                    ZenDiscovery.this.currentJoinThread = null;
                }
            }
        });
    }

    private void innerJoinCluster() {
        boolean retry = true;
        while (retry) {
            if (this.lifecycle.stoppedOrClosed()) {
                return;
            }
            retry = false;
            DiscoveryNode masterNode = this.findMaster();
            if (masterNode == null) {
                this.logger.trace("no masterNode returned", new Object[0]);
                retry = true;
                continue;
            }
            if (this.localNode.equals(masterNode)) {
                this.master = true;
                this.nodesFD.start();
                this.clusterService.submitStateUpdateTask("zen-disco-join (elected_as_master)", Priority.URGENT, new ProcessedClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder builder = new DiscoveryNodes.Builder().localNodeId(ZenDiscovery.this.localNode.id()).masterNodeId(ZenDiscovery.this.localNode.id()).put(ZenDiscovery.this.localNode);
                        ZenDiscovery.this.latestDiscoNodes = builder.build();
                        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(Discovery.NO_MASTER_BLOCK).build();
                        return ClusterState.builder(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).blocks(clusterBlocks).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        ZenDiscovery.this.sendInitialStateEventIfNeeded();
                    }
                });
                continue;
            }
            this.master = false;
            try {
                this.transportService.connectToNode(masterNode);
            }
            catch (Exception e) {
                this.logger.warn("failed to connect to master [{}], retrying...", e, masterNode);
                retry = true;
                continue;
            }
            try {
                this.membership.sendJoinRequestBlocking(masterNode, this.localNode, this.pingTimeout);
            }
            catch (Exception e) {
                if (e instanceof ElasticsearchException) {
                    this.logger.info("failed to send join request to master [{}], reason [{}]", masterNode, ((ElasticsearchException)e).getDetailedMessage());
                } else {
                    this.logger.info("failed to send join request to master [{}], reason [{}]", masterNode, e.getMessage());
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("detailed failed reason", e, new Object[0]);
                }
                retry = true;
                continue;
            }
            this.masterFD.start(masterNode, "initial_join");
        }
    }

    private void handleLeaveRequest(final DiscoveryNode node) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.master) {
            this.clusterService.submitStateUpdateTask("zen-disco-node_left(" + node + ")", Priority.IMMEDIATE, new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    DiscoveryNodes.Builder builder = DiscoveryNodes.builder(currentState.nodes()).remove(node.id());
                    ZenDiscovery.this.latestDiscoNodes = builder.build();
                    currentState = ClusterState.builder(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
                    if (!ZenDiscovery.this.electMaster.hasEnoughMasterNodes(currentState.nodes())) {
                        return ZenDiscovery.this.rejoin(currentState, "not enough master nodes");
                    }
                    RoutingAllocation.Result routingResult = ZenDiscovery.this.allocationService.reroute(ClusterState.builder(currentState).build());
                    return ClusterState.builder(currentState).routingResult(routingResult).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                }
            });
        } else {
            this.handleMasterGone(node, "shut_down");
        }
    }

    private void handleNodeFailure(final DiscoveryNode node, String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (!this.master) {
            return;
        }
        this.clusterService.submitStateUpdateTask("zen-disco-node_failed(" + node + "), reason " + reason, Priority.IMMEDIATE, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                DiscoveryNodes.Builder builder = DiscoveryNodes.builder(currentState.nodes()).remove(node.id());
                ZenDiscovery.this.latestDiscoNodes = builder.build();
                currentState = ClusterState.builder(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
                if (!ZenDiscovery.this.electMaster.hasEnoughMasterNodes(currentState.nodes())) {
                    return ZenDiscovery.this.rejoin(currentState, "not enough master nodes");
                }
                RoutingAllocation.Result routingResult = ZenDiscovery.this.allocationService.reroute(ClusterState.builder(currentState).build());
                return ClusterState.builder(currentState).routingResult(routingResult).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ZenDiscovery.this.sendInitialStateEventIfNeeded();
            }
        });
    }

    private void handleMinimumMasterNodesChanged(final int minimumMasterNodes) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        final int prevMinimumMasterNode = this.electMaster.minimumMasterNodes();
        this.electMaster.minimumMasterNodes(minimumMasterNodes);
        if (!this.master) {
            return;
        }
        this.clusterService.submitStateUpdateTask("zen-disco-minimum_master_nodes_changed", Priority.IMMEDIATE, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (!ZenDiscovery.this.electMaster.hasEnoughMasterNodes(currentState.nodes())) {
                    return ZenDiscovery.this.rejoin(currentState, "not enough master nodes on change of minimum_master_nodes from [" + prevMinimumMasterNode + "] to [" + minimumMasterNodes + "]");
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ZenDiscovery.this.sendInitialStateEventIfNeeded();
            }
        });
    }

    private void handleMasterGone(final DiscoveryNode masterNode, final String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.master) {
            return;
        }
        this.logger.info("master_left [{}], reason [{}]", masterNode, reason);
        this.clusterService.submitStateUpdateTask("zen-disco-master_failed (" + masterNode + ")", Priority.IMMEDIATE, new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (!masterNode.id().equals(currentState.nodes().masterNodeId())) {
                    return currentState;
                }
                DiscoveryNodes discoveryNodes = DiscoveryNodes.builder(currentState.nodes()).remove(masterNode.id()).masterNodeId(null).build();
                if (!ZenDiscovery.this.electMaster.hasEnoughMasterNodes(discoveryNodes)) {
                    return ZenDiscovery.this.rejoin(ClusterState.builder(currentState).nodes(discoveryNodes).build(), "not enough master nodes after master left (reason = " + reason + ")");
                }
                DiscoveryNode electedMaster = ZenDiscovery.this.electMaster.electMaster(discoveryNodes);
                if (ZenDiscovery.this.localNode.equals(electedMaster)) {
                    ZenDiscovery.this.master = true;
                    ZenDiscovery.this.masterFD.stop("got elected as new master since master left (reason = " + reason + ")");
                    ZenDiscovery.this.nodesFD.start();
                    discoveryNodes = DiscoveryNodes.builder(discoveryNodes).masterNodeId(ZenDiscovery.this.localNode.id()).build();
                    ZenDiscovery.this.latestDiscoNodes = discoveryNodes;
                    return ClusterState.builder(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
                }
                ZenDiscovery.this.nodesFD.stop();
                if (electedMaster != null) {
                    discoveryNodes = DiscoveryNodes.builder(discoveryNodes).masterNodeId(electedMaster.id()).build();
                    ZenDiscovery.this.masterFD.restart(electedMaster, "possible elected master since master left (reason = " + reason + ")");
                    ZenDiscovery.this.latestDiscoNodes = discoveryNodes;
                    return ClusterState.builder(currentState).nodes(ZenDiscovery.this.latestDiscoNodes).build();
                }
                return ZenDiscovery.this.rejoin(ClusterState.builder(currentState).nodes(discoveryNodes).build(), "master_left and no other node elected to become master");
            }

            @Override
            public void onFailure(String source, Throwable t) {
                ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ZenDiscovery.this.sendInitialStateEventIfNeeded();
            }
        });
    }

    void handleNewClusterStateFromMaster(ClusterState newClusterState, final PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed) {
        if (this.master) {
            final ClusterState newState = newClusterState;
            this.clusterService.submitStateUpdateTask("zen-disco-master_receive_cluster_state_from_another_master [" + newState.nodes().masterNode() + "]", Priority.URGENT, new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (newState.version() > currentState.version()) {
                        ZenDiscovery.this.logger.warn("received cluster state from [{}] which is also master but with a newer cluster_state, rejoining to cluster...", newState.nodes().masterNode());
                        return ZenDiscovery.this.rejoin(currentState, "zen-disco-master_receive_cluster_state_from_another_master [" + newState.nodes().masterNode() + "]");
                    }
                    ZenDiscovery.this.logger.warn("received cluster state from [{}] which is also master but with an older cluster_state, telling [{}] to rejoin the cluster", newState.nodes().masterNode(), newState.nodes().masterNode());
                    ZenDiscovery.this.transportService.sendRequest(newState.nodes().masterNode(), "discovery/zen/rejoin", new RejoinClusterRequest(currentState.nodes().localNodeId()), new EmptyTransportResponseHandler("same"){

                        @Override
                        public void handleException(TransportException exp) {
                            ZenDiscovery.this.logger.warn("failed to send rejoin request to [{}]", exp, newState.nodes().masterNode());
                        }
                    });
                    return currentState;
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState2) {
                    newStateProcessed.onNewClusterStateProcessed();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    newStateProcessed.onNewClusterStateFailed(t);
                }
            });
        } else if (newClusterState.nodes().localNode() == null) {
            this.logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", newClusterState.nodes().masterNode());
            newStateProcessed.onNewClusterStateFailed(new ElasticsearchIllegalStateException("received state from a node that is not part of the cluster"));
        } else {
            if (this.currentJoinThread != null) {
                this.logger.debug("got a new state from master node, though we are already trying to rejoin the cluster", new Object[0]);
            }
            final ProcessClusterState processClusterState = new ProcessClusterState(newClusterState, newStateProcessed);
            this.processNewClusterStates.add(processClusterState);
            this.clusterService.submitStateUpdateTask("zen-disco-receive(from master [" + newClusterState.nodes().masterNode() + "])", Priority.URGENT, new ProcessedClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ProcessClusterState potentialState;
                    if (processClusterState.processed) {
                        return currentState;
                    }
                    ProcessClusterState stateToProcess = (ProcessClusterState)ZenDiscovery.this.processNewClusterStates.poll();
                    if (stateToProcess == null) {
                        return currentState;
                    }
                    stateToProcess.processed = true;
                    while ((potentialState = (ProcessClusterState)ZenDiscovery.this.processNewClusterStates.peek()) != null && Objects.equal(stateToProcess.clusterState.nodes().masterNodeId(), potentialState.clusterState.nodes().masterNodeId())) {
                        potentialState = (ProcessClusterState)ZenDiscovery.this.processNewClusterStates.poll();
                        potentialState.processed = true;
                        if (potentialState.clusterState.version() <= stateToProcess.clusterState.version()) continue;
                        stateToProcess = potentialState;
                    }
                    ClusterState updatedState = stateToProcess.clusterState;
                    if (updatedState.version() < currentState.version() && Objects.equal(updatedState.nodes().masterNodeId(), currentState.nodes().masterNodeId())) {
                        return currentState;
                    }
                    ZenDiscovery.this.latestDiscoNodes = updatedState.nodes();
                    if (ZenDiscovery.this.masterFD.masterNode() == null || !ZenDiscovery.this.masterFD.masterNode().equals(ZenDiscovery.this.latestDiscoNodes.masterNode())) {
                        ZenDiscovery.this.masterFD.restart(ZenDiscovery.this.latestDiscoNodes.masterNode(), "new cluster state received and we are monitoring the wrong master [" + ZenDiscovery.this.masterFD.masterNode() + "]");
                    }
                    ClusterState.Builder builder = ClusterState.builder(updatedState);
                    if (updatedState.routingTable().version() == currentState.routingTable().version()) {
                        builder.routingTable(currentState.routingTable());
                    }
                    if (updatedState.metaData().version() == currentState.metaData().version()) {
                        builder.metaData(currentState.metaData());
                    } else {
                        MetaData.Builder metaDataBuilder = MetaData.builder(updatedState.metaData()).removeAllIndices();
                        for (IndexMetaData indexMetaData : updatedState.metaData()) {
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(indexMetaData.index());
                            if (currentIndexMetaData == null || currentIndexMetaData.version() != indexMetaData.version()) {
                                metaDataBuilder.put(indexMetaData, false);
                                continue;
                            }
                            metaDataBuilder.put(currentIndexMetaData, false);
                        }
                        builder.metaData(metaDataBuilder);
                    }
                    return builder.build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    newStateProcessed.onNewClusterStateFailed(t);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    ZenDiscovery.this.sendInitialStateEventIfNeeded();
                    newStateProcessed.onNewClusterStateProcessed();
                }
            });
        }
    }

    private ClusterState handleJoinRequest(final DiscoveryNode node) {
        if (!this.master) {
            throw new ElasticsearchIllegalStateException("Node [" + this.localNode + "] not master for join request from [" + node + "]");
        }
        ClusterState state = this.clusterService.state();
        if (!this.transportService.addressSupported(node.address().getClass())) {
            this.logger.warn("received a wrong address type from [{}], ignoring...", node);
        } else {
            this.transportService.connectToNode(node);
            state = this.clusterService.state();
            this.membership.sendValidateJoinRequestBlocking(node, state, this.pingTimeout);
            this.clusterService.submitStateUpdateTask("zen-disco-receive(join from node[" + node + "])", Priority.IMMEDIATE, new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    if (currentState.nodes().nodeExists(node.id())) {
                        ZenDiscovery.this.logger.warn("received a join request for an existing node [{}]", node);
                        return ClusterState.builder(currentState).build();
                    }
                    DiscoveryNodes.Builder builder = DiscoveryNodes.builder(currentState.nodes());
                    for (DiscoveryNode existingNode : currentState.nodes()) {
                        if (!node.address().equals(existingNode.address())) continue;
                        builder.remove(existingNode.id());
                        ZenDiscovery.this.logger.warn("received join request from node [{}], but found existing node {} with same address, removing existing node", node, existingNode);
                    }
                    ZenDiscovery.this.latestDiscoNodes = builder.build();
                    return ClusterState.builder(currentState).nodes(ZenDiscovery.this.latestDiscoNodes.newNode(node)).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                }
            });
        }
        return state;
    }

    private DiscoveryNode findMaster() {
        DiscoveryNode electedMaster;
        ZenPing.PingResponse[] fullPingResponses = this.pingService.pingAndWait(this.pingTimeout);
        if (fullPingResponses == null) {
            this.logger.trace("No full ping responses", new Object[0]);
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("full ping responses:");
            if (fullPingResponses.length == 0) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : fullPingResponses) {
                    sb.append("\n\t--> ").append("target [").append(pingResponse.target()).append("], master [").append(pingResponse.master()).append("]");
                }
            }
            this.logger.trace(sb.toString(), new Object[0]);
        }
        ArrayList<ZenPing.PingResponse> pingResponses = Lists.newArrayList();
        for (ZenPing.PingResponse pingResponse : fullPingResponses) {
            DiscoveryNode node = pingResponse.target();
            if (this.masterElectionFilterClientNodes && (node.clientNode() || !node.masterNode() && !node.dataNode()) || this.masterElectionFilterDataNodes && !node.masterNode() && node.dataNode()) continue;
            pingResponses.add(pingResponse);
        }
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("filtered ping responses: (filter_client[").append(this.masterElectionFilterClientNodes).append("], filter_data[").append(this.masterElectionFilterDataNodes).append("])");
            if (pingResponses.isEmpty()) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : pingResponses) {
                    sb.append("\n\t--> ").append("target [").append(pingResponse.target()).append("], master [").append(pingResponse.master()).append("]");
                }
            }
            this.logger.debug(sb.toString(), new Object[0]);
        }
        ArrayList<DiscoveryNode> pingMasters = Lists.newArrayList();
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            if (pingResponse.master() == null) continue;
            pingMasters.add(pingResponse.master());
        }
        HashSet<DiscoveryNode> possibleMasterNodes = Sets.newHashSet();
        possibleMasterNodes.add(this.localNode);
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            possibleMasterNodes.add(pingResponse.target());
        }
        if (!this.electMaster.hasEnoughMasterNodes(possibleMasterNodes)) {
            return null;
        }
        if (pingMasters.isEmpty()) {
            electedMaster = this.electMaster.electMaster(possibleMasterNodes);
            if (this.localNode.equals(electedMaster)) {
                return this.localNode;
            }
        } else {
            electedMaster = this.electMaster.electMaster(pingMasters);
            if (electedMaster != null) {
                return electedMaster;
            }
        }
        return null;
    }

    private ClusterState rejoin(ClusterState clusterState, String reason) {
        this.logger.warn(reason + ", current nodes: {}", clusterState.nodes());
        this.nodesFD.stop();
        this.masterFD.stop(reason);
        this.master = false;
        ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(clusterState.blocks()).addGlobalBlock(NO_MASTER_BLOCK).addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build();
        RoutingTable routingTable = RoutingTable.builder().build();
        MetaData metaData = MetaData.builder().build();
        this.latestDiscoNodes = new DiscoveryNodes.Builder().put(this.localNode).localNodeId(this.localNode.id()).build();
        this.asyncJoinCluster();
        return ClusterState.builder(clusterState).blocks(clusterBlocks).nodes(this.latestDiscoNodes).routingTable(routingTable).metaData(metaData).build();
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int minimumMasterNodes = settings.getAsInt("discovery.zen.minimum_master_nodes", (Integer)ZenDiscovery.this.electMaster.minimumMasterNodes());
            if (minimumMasterNodes != ZenDiscovery.this.electMaster.minimumMasterNodes()) {
                ZenDiscovery.this.logger.info("updating {} from [{}] to [{}]", "discovery.zen.minimum_master_nodes", ZenDiscovery.this.electMaster.minimumMasterNodes(), minimumMasterNodes);
                ZenDiscovery.this.handleMinimumMasterNodesChanged(minimumMasterNodes);
            }
        }
    }

    class RejoinClusterRequestHandler
    extends BaseTransportRequestHandler<RejoinClusterRequest> {
        static final String ACTION = "discovery/zen/rejoin";

        RejoinClusterRequestHandler() {
        }

        @Override
        public RejoinClusterRequest newInstance() {
            return new RejoinClusterRequest();
        }

        @Override
        public void messageReceived(final RejoinClusterRequest request, final TransportChannel channel) throws Exception {
            ZenDiscovery.this.clusterService.submitStateUpdateTask("received a request to rejoin the cluster from [" + request.fromNodeId + "]", Priority.URGENT, new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    try {
                        channel.sendResponse(TransportResponse.Empty.INSTANCE);
                    }
                    catch (Exception e) {
                        ZenDiscovery.this.logger.warn("failed to send response on rejoin cluster request handling", e, new Object[0]);
                    }
                    return ZenDiscovery.this.rejoin(currentState, "received a request to rejoin the cluster from [" + request.fromNodeId + "]");
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    ZenDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    static class RejoinClusterRequest
    extends TransportRequest {
        private String fromNodeId;

        RejoinClusterRequest(String fromNodeId) {
            this.fromNodeId = fromNodeId;
        }

        RejoinClusterRequest() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.fromNodeId = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.fromNodeId);
        }
    }

    private class MasterNodeFailureListener
    implements MasterFaultDetection.Listener {
        private MasterNodeFailureListener() {
        }

        @Override
        public void onMasterFailure(DiscoveryNode masterNode, String reason) {
            ZenDiscovery.this.handleMasterGone(masterNode, reason);
        }

        @Override
        public void onDisconnectedFromMaster() {
            DiscoveryNode masterNode = ZenDiscovery.this.latestDiscoNodes.masterNode();
            try {
                ZenDiscovery.this.membership.sendJoinRequest(masterNode, ZenDiscovery.this.localNode);
            }
            catch (Exception e) {
                ZenDiscovery.this.logger.warn("failed to send join request on disconnection from master [{}]", masterNode);
            }
        }
    }

    private class NodeFailureListener
    implements NodesFaultDetection.Listener {
        private NodeFailureListener() {
        }

        @Override
        public void onNodeFailure(DiscoveryNode node, String reason) {
            ZenDiscovery.this.handleNodeFailure(node, reason);
        }
    }

    private class MembershipListener
    implements MembershipAction.MembershipListener {
        private MembershipListener() {
        }

        @Override
        public ClusterState onJoin(DiscoveryNode node) {
            return ZenDiscovery.this.handleJoinRequest(node);
        }

        @Override
        public void onLeave(DiscoveryNode node) {
            ZenDiscovery.this.handleLeaveRequest(node);
        }
    }

    private class NewClusterStateListener
    implements PublishClusterStateAction.NewClusterStateListener {
        private NewClusterStateListener() {
        }

        @Override
        public void onNewClusterState(ClusterState clusterState, PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed) {
            ZenDiscovery.this.handleNewClusterStateFromMaster(clusterState, newStateProcessed);
        }
    }

    static class ProcessClusterState {
        final ClusterState clusterState;
        final PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed;
        volatile boolean processed;

        ProcessClusterState(ClusterState clusterState, PublishClusterStateAction.NewClusterStateListener.NewStateProcessed newStateProcessed) {
            this.clusterState = clusterState;
            this.newStateProcessed = newStateProcessed;
        }
    }
}

