/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tribe;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.node.internal.InternalNode;
import org.elasticsearch.rest.RestStatus;

public class TribeService
extends AbstractLifecycleComponent<TribeService> {
    public static final ClusterBlock TRIBE_METADATA_BLOCK = new ClusterBlock(10, "tribe node, metadata not allowed", false, false, RestStatus.BAD_REQUEST, ClusterBlockLevel.METADATA);
    public static final ClusterBlock TRIBE_WRITE_BLOCK = new ClusterBlock(11, "tribe node, write not allowed", false, false, RestStatus.BAD_REQUEST, ClusterBlockLevel.WRITE);
    public static final String TRIBE_NAME = "tribe.name";
    private final ClusterService clusterService;
    private final List<InternalNode> nodes = Lists.newCopyOnWriteArrayList();

    public static Settings processSettings(Settings settings) {
        if (settings.get(TRIBE_NAME) != null) {
            ImmutableSettings.Builder sb = ImmutableSettings.builder().put(settings);
            for (String s : settings.getAsMap().keySet()) {
                if (!s.startsWith("tribe.") || s.equals(TRIBE_NAME)) continue;
                sb.remove(s);
            }
            return sb.build();
        }
        Map<String, Settings> nodesSettings = settings.getGroups("tribe", true);
        if (nodesSettings.isEmpty()) {
            return settings;
        }
        ImmutableSettings.Builder sb = ImmutableSettings.builder().put(settings);
        sb.put("node.client", true);
        sb.put("discovery.type", "local");
        sb.put("discovery.initial_state_timeout", 0);
        if (sb.get("cluster.name") == null) {
            sb.put("cluster.name", "tribe_" + Strings.randomBase64UUID());
        }
        sb.put("gateway.type", "none");
        sb.put("action.master.force_local", true);
        return sb.build();
    }

    @Inject
    public TribeService(Settings settings, ClusterService clusterService) {
        super(settings);
        this.clusterService = clusterService;
        HashMap<String, Settings> nodesSettings = Maps.newHashMap(settings.getGroups("tribe", true));
        nodesSettings.remove("blocks");
        for (Map.Entry entry : nodesSettings.entrySet()) {
            ImmutableSettings.Builder sb = ImmutableSettings.builder().put((Settings)entry.getValue());
            sb.put("node.name", settings.get("name") + "/" + (String)entry.getKey());
            sb.put(TRIBE_NAME, (String)entry.getKey());
            if (sb.get("http.enabled") == null) {
                sb.put("http.enabled", false);
            }
            this.nodes.add((InternalNode)NodeBuilder.nodeBuilder().settings(sb).client(true).build());
        }
        if (!this.nodes.isEmpty()) {
            clusterService.removeInitialStateBlock(Discovery.NO_MASTER_BLOCK);
            clusterService.removeInitialStateBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
            if (settings.getAsBoolean("tribe.blocks.write", (Boolean)false).booleanValue()) {
                clusterService.addInitialStateBlock(TRIBE_WRITE_BLOCK);
            }
            if (settings.getAsBoolean("tribe.blocks.metadata", (Boolean)false).booleanValue()) {
                clusterService.addInitialStateBlock(TRIBE_METADATA_BLOCK);
            }
            for (InternalNode node : this.nodes) {
                node.injector().getInstance(ClusterService.class).add(new TribeClusterStateListener(node));
            }
        }
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.clusterService.submitStateUpdateTask("updating local node id", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return ClusterState.builder(currentState).nodes(DiscoveryNodes.builder(currentState.nodes()).put(TribeService.this.clusterService.localNode()).localNodeId(TribeService.this.clusterService.localNode().id())).build();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(String source, Throwable t) {
                try {
                    TribeService.this.logger.error("{}", t, source);
                }
                finally {
                    latch.countDown();
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchIllegalStateException("Interrupted while starting [" + this.getClass().getSimpleName() + "]", e);
        }
        for (InternalNode node : this.nodes) {
            try {
                node.start();
            }
            catch (Throwable e) {
                for (InternalNode otherNode : this.nodes) {
                    try {
                        otherNode.close();
                    }
                    catch (Throwable t) {
                        this.logger.warn("failed to close node {} on failed start", otherNode, t);
                    }
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ElasticsearchException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        for (InternalNode node : this.nodes) {
            try {
                node.stop();
            }
            catch (Throwable t) {
                this.logger.warn("failed to stop node {}", t, node);
            }
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        for (InternalNode node : this.nodes) {
            try {
                node.close();
            }
            catch (Throwable t) {
                this.logger.warn("failed to close node {}", t, node);
            }
        }
    }

    class TribeClusterStateListener
    implements ClusterStateListener {
        private final InternalNode tribeNode;
        private final String tribeName;

        TribeClusterStateListener(InternalNode tribeNode) {
            this.tribeNode = tribeNode;
            this.tribeName = tribeNode.settings().get(TribeService.TRIBE_NAME);
        }

        @Override
        public void clusterChanged(final ClusterChangedEvent event) {
            TribeService.this.logger.debug("[{}] received cluster event, [{}]", this.tribeName, event.source());
            TribeService.this.clusterService.submitStateUpdateTask("cluster event from " + this.tribeName + ", " + event.source(), new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    ClusterState tribeState = event.state();
                    DiscoveryNodes.Builder nodes = DiscoveryNodes.builder(currentState.nodes());
                    for (DiscoveryNode discoNode : currentState.nodes()) {
                        String markedTribeName = discoNode.attributes().get(TribeService.TRIBE_NAME);
                        if (markedTribeName == null || !markedTribeName.equals(TribeClusterStateListener.this.tribeName) || tribeState.nodes().get(discoNode.id()) != null) continue;
                        TribeService.this.logger.info("[{}] removing node [{}]", TribeClusterStateListener.this.tribeName, discoNode);
                        nodes.remove(discoNode.id());
                    }
                    for (DiscoveryNode tribe : tribeState.nodes()) {
                        if (currentState.nodes().get(tribe.id()) != null) continue;
                        ImmutableMap<String, String> tribeAttr = MapBuilder.newMapBuilder(tribe.attributes()).put(TribeService.TRIBE_NAME, TribeClusterStateListener.this.tribeName).immutableMap();
                        DiscoveryNode discoNode = new DiscoveryNode(tribe.name(), tribe.id(), tribe.getHostName(), tribe.getHostAddress(), tribe.address(), tribeAttr, tribe.version());
                        TribeService.this.logger.info("[{}] adding node [{}]", TribeClusterStateListener.this.tribeName, discoNode);
                        nodes.put(discoNode);
                    }
                    MetaData.Builder metaData = MetaData.builder(currentState.metaData());
                    RoutingTable.Builder routingTable = RoutingTable.builder(currentState.routingTable());
                    for (IndexMetaData index : currentState.metaData()) {
                        String markedTribeName = index.settings().get(TribeService.TRIBE_NAME);
                        if (markedTribeName == null || !markedTribeName.equals(TribeClusterStateListener.this.tribeName)) continue;
                        IndexMetaData tribeIndex = tribeState.metaData().index(index.index());
                        if (tribeIndex == null) {
                            TribeService.this.logger.info("[{}] removing index [{}]", TribeClusterStateListener.this.tribeName, index.index());
                            metaData.remove(index.index());
                            routingTable.remove(index.index());
                            continue;
                        }
                        routingTable.add(tribeState.routingTable().index(index.index()));
                        Settings tribeSettings = ImmutableSettings.builder().put(tribeIndex.settings()).put(TribeService.TRIBE_NAME, TribeClusterStateListener.this.tribeName).build();
                        metaData.put(IndexMetaData.builder(tribeIndex).settings(tribeSettings));
                    }
                    for (IndexMetaData tribeIndex : tribeState.metaData()) {
                        if (currentState.metaData().hasIndex(tribeIndex.index())) continue;
                        TribeService.this.logger.info("[{}] adding index [{}]", TribeClusterStateListener.this.tribeName, tribeIndex.index());
                        Settings tribeSettings = ImmutableSettings.builder().put(tribeIndex.settings()).put(TribeService.TRIBE_NAME, TribeClusterStateListener.this.tribeName).build();
                        metaData.put(IndexMetaData.builder(tribeIndex).settings(tribeSettings));
                        routingTable.add(tribeState.routingTable().index(tribeIndex.index()));
                    }
                    return ClusterState.builder(currentState).nodes(nodes).metaData(metaData).routingTable(routingTable).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    TribeService.this.logger.warn("failed to process [{}]", t, source);
                }
            });
        }
    }
}

