/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.config;

import java.io.Serializable;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="elasticSearchRemote")
public class ElasticSearchRemoteConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@clusterName")
    protected String clusterName;
    @XNode(value="@addressList")
    protected String addressList;
    @XNode(value="@clientTransportSniff")
    protected boolean clientTransportSniff = false;
    @XNode(value="@clientTransportIgnoreClusterName")
    protected boolean clientTransportIgnoreClusterName = false;
    @XNode(value="@clientTransportPingTimeout")
    protected String clientTransportPingTimeout = "5s";
    @XNode(value="@clientTransportNodesSamplerInterval")
    protected String clientTransportNodesSamplerInterval = "5s";
    @XNode(value="@indexNumberOfShards")
    protected String numberOfShards = "1";
    @XNode(value="@indexNumberOfReplicas")
    protected String numberOfReplicas = "0";

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String[] getAddresses() {
        if (this.addressList != null) {
            return this.addressList.split(",");
        }
        return null;
    }

    public boolean isIgnoreClusterName() {
        return this.clientTransportIgnoreClusterName;
    }

    public boolean isClusterSniff() {
        return this.clientTransportSniff;
    }

    public String getPingTimeout() {
        return this.clientTransportPingTimeout;
    }

    public String getSamplerInterval() {
        return this.clientTransportNodesSamplerInterval;
    }

    public String getNumberOfShards() {
        return this.numberOfShards;
    }

    public String getNumberOfReplicas() {
        return this.numberOfReplicas;
    }
}

