/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.provider;

import java.security.Principal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.elasticsearch.nxql.NxqlQueryConverter;

public class ElasticSearchQueryBuilder {
    public static QueryBuilder makeQuery(String pattern, Object[] params, boolean quotePatternParameters, boolean escapePatternParameters, boolean useNativeQuery) throws ClientException {
        String query = pattern;
        for (int i = 0; i < params.length; ++i) {
            query = query.replaceFirst("\\?", ElasticSearchQueryBuilder.convertParam(params[i], quotePatternParameters));
        }
        if (useNativeQuery) {
            return QueryBuilders.queryString((String)query);
        }
        return NxqlQueryConverter.toESQueryBuilder(query);
    }

    public static QueryBuilder makeQuery(DocumentModel model, WhereClauseDefinition whereClause, Object[] params, boolean useNativeQuery) throws ClientException {
        assert (model != null);
        assert (whereClause != null);
        NxqlQueryConverter.ExpressionBuilder eb = new NxqlQueryConverter.ExpressionBuilder("AND");
        String fixedPart = whereClause.getFixedPart();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                fixedPart = fixedPart.replaceFirst("\\?", ElasticSearchQueryBuilder.convertParam(params[i], true));
            }
            if (useNativeQuery) {
                eb.add((QueryBuilder)QueryBuilders.queryString((String)fixedPart));
            } else {
                eb.add(NxqlQueryConverter.toESQueryBuilder(fixedPart));
            }
        }
        for (PredicateDefinition predicate : whereClause.getPredicates()) {
            Object[] values;
            PredicateFieldDefinition[] fieldDef = predicate.getValues();
            try {
                values = new Object[fieldDef.length];
                for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                    values[fidx] = fieldDef[fidx].getXpath() != null ? model.getPropertyValue(fieldDef[fidx].getXpath()) : model.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
                }
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            if (!ElasticSearchQueryBuilder.isNonNullParam(values)) continue;
            Object value = values[0];
            if (values[0] instanceof Collection) {
                Collection vals = (Collection)values[0];
                values = vals.toArray(new Object[vals.size()]);
            } else if (values[0] instanceof Object[]) {
                values = (Object[])values[0];
            }
            String name = predicate.getParameter();
            String operator = predicate.getOperator().toUpperCase();
            if ("FULLTEXT".equals(operator) || "FULLTEXT ALL".equals(operator)) {
                operator = "=";
                if (!name.startsWith("ecm:fulltext")) {
                    name = "ecm:fulltext." + name;
                }
            }
            eb.add(NxqlQueryConverter.makeQueryFromSimpleExpression(operator, name, value, values));
        }
        return eb.get();
    }

    protected static TermsFilterBuilder getSecurityFilter(Principal principal) {
        String[] principals;
        if (principal != null && (principals = SecurityService.getPrincipalsToCheck((Principal)principal)).length > 0) {
            return FilterBuilders.inFilter((String)"ecm:acl", (String[])principals);
        }
        return null;
    }

    protected static void addSortInfo(SearchRequestBuilder builder, SortInfo[] sortInfos) {
        for (SortInfo sortInfo : sortInfos) {
            builder.addSort(sortInfo.getSortColumn(), sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC);
        }
    }

    protected static String convertFieldName(String parameter) {
        return parameter.replace(":", "\\:");
    }

    protected static String convertParam(Object param, boolean quote) {
        String ret;
        if (param == null) {
            ret = "";
        } else if (param instanceof Boolean) {
            ret = ((Boolean)param).toString();
        } else if (param instanceof Calendar) {
            ret = DateParser.formatW3CDateTime((Date)((Calendar)param).getTime());
        } else if (param instanceof Double) {
            ret = ((Double)param).toString();
        } else if (param instanceof Integer) {
            ret = ((Integer)param).toString();
        } else {
            ret = param.toString();
            if (quote) {
                ret = "\"" + ret + "\"";
            }
        }
        return ret;
    }

    protected static boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            if (v instanceof Collection) {
                if (((Collection)v).isEmpty()) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

