/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class AnalyzeResponse
extends ActionResponse
implements Iterable<AnalyzeToken>,
ToXContent {
    private List<AnalyzeToken> tokens;

    AnalyzeResponse() {
    }

    public AnalyzeResponse(List<AnalyzeToken> tokens) {
        this.tokens = tokens;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens;
    }

    @Override
    public Iterator<AnalyzeToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.TOKENS);
        for (AnalyzeToken token : this.tokens) {
            builder.startObject();
            builder.field(Fields.TOKEN, token.getTerm());
            builder.field(Fields.START_OFFSET, token.getStartOffset());
            builder.field(Fields.END_OFFSET, token.getEndOffset());
            builder.field(Fields.TYPE, token.getType());
            builder.field(Fields.POSITION, token.getPosition());
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.tokens = new ArrayList<AnalyzeToken>(size);
        for (int i = 0; i < size; ++i) {
            this.tokens.add(AnalyzeToken.readAnalyzeToken(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.tokens.size());
        for (AnalyzeToken token : this.tokens) {
            token.writeTo(out);
        }
    }

    static final class Fields {
        static final XContentBuilderString TOKENS = new XContentBuilderString("tokens");
        static final XContentBuilderString TOKEN = new XContentBuilderString("token");
        static final XContentBuilderString START_OFFSET = new XContentBuilderString("start_offset");
        static final XContentBuilderString END_OFFSET = new XContentBuilderString("end_offset");
        static final XContentBuilderString TYPE = new XContentBuilderString("type");
        static final XContentBuilderString POSITION = new XContentBuilderString("position");

        Fields() {
        }
    }

    public static class AnalyzeToken
    implements Streamable {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private String type;

        AnalyzeToken() {
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, String type) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
        }

        public String getTerm() {
            return this.term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public String getType() {
            return this.type;
        }

        public static AnalyzeToken readAnalyzeToken(StreamInput in) throws IOException {
            AnalyzeToken analyzeToken = new AnalyzeToken();
            analyzeToken.readFrom(in);
            return analyzeToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            this.type = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            out.writeOptionalString(this.type);
        }
    }
}

