/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.queries.XTermsFilter;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class IdsQueryParser
implements QueryParser {
    public static final String NAME = "ids";

    @Inject
    public IdsQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ArrayList<BytesRef> ids = new ArrayList<BytesRef>();
        Collection<String> types = null;
        String currentFieldName = null;
        float boost = 1.0f;
        String queryName = null;
        boolean idsProvided = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                Object value;
                if ("values".equals(currentFieldName)) {
                    idsProvided = true;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        value = parser.bytesOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for term filter");
                        }
                        ids.add((BytesRef)value);
                    }
                    continue;
                }
                if ("types".equals(currentFieldName) || "type".equals(currentFieldName)) {
                    types = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        value = parser.textOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No type specified for term filter");
                        }
                        types.add((String)value);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[ids] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "_type".equals(currentFieldName)) {
                types = ImmutableList.of(parser.text());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[ids] query does not support [" + currentFieldName + "]");
        }
        if (!idsProvided) {
            throw new QueryParsingException(parseContext.index(), "[ids] query, no ids values provided");
        }
        if (ids.isEmpty()) {
            return Queries.newMatchNoDocsQuery();
        }
        if (types == null || types.isEmpty()) {
            types = parseContext.queryTypes();
        } else if (types.size() == 1 && ((String)Iterables.getFirst(types, null)).equals("_all")) {
            types = parseContext.mapperService().types();
        }
        XTermsFilter filter = new XTermsFilter("_uid", Uid.createTypeUids(types, ids));
        ConstantScoreQuery query = new ConstantScoreQuery((Filter)filter);
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)query);
        }
        return query;
    }
}

