/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.routing;

import java.io.IOException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.river.RiverName;

public class RiverRouting
implements Streamable {
    private RiverName riverName;
    private DiscoveryNode node;

    private RiverRouting() {
    }

    RiverRouting(RiverName riverName, DiscoveryNode node) {
        this.riverName = riverName;
        this.node = node;
    }

    public RiverName riverName() {
        return this.riverName;
    }

    public DiscoveryNode node() {
        return this.node;
    }

    void node(DiscoveryNode node) {
        this.node = node;
    }

    public static RiverRouting readRiverRouting(StreamInput in) throws IOException {
        RiverRouting routing = new RiverRouting();
        routing.readFrom(in);
        return routing;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.riverName = new RiverName(in.readString(), in.readString());
        if (in.readBoolean()) {
            this.node = DiscoveryNode.readNode(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.riverName.type());
        out.writeString(this.riverName.name());
        if (this.node == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.node.writeTo(out);
        }
    }
}

