/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatterStreams;

public class InternalRange<B extends Bucket>
extends InternalAggregation
implements Range {
    static final Factory FACTORY = new Factory();
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("range");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalRange readResult(StreamInput in) throws IOException {
            InternalRange ranges = new InternalRange();
            ranges.readFrom(in);
            return ranges;
        }
    };
    private List<B> ranges;
    private Map<String, B> rangeMap;
    private ValueFormatter formatter;
    private boolean keyed;
    private boolean unmapped;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    public InternalRange() {
    }

    public InternalRange(String name, List<B> ranges, ValueFormatter formatter, boolean keyed, boolean unmapped) {
        super(name);
        this.ranges = ranges;
        this.formatter = formatter;
        this.keyed = keyed;
        this.unmapped = unmapped;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public Collection<B> getBuckets() {
        return this.ranges;
    }

    @Override
    public B getBucketByKey(String key) {
        if (this.rangeMap == null) {
            this.rangeMap = new HashMap<String, B>(this.ranges.size());
            for (Bucket bucket : this.ranges) {
                this.rangeMap.put(bucket.getKey(), bucket);
            }
        }
        return (B)((Bucket)this.rangeMap.get(key));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            InternalRange reduced = (InternalRange)aggregations.get(0);
            for (Bucket bucket : reduced.ranges) {
                bucket.aggregations.reduce(reduceContext.bigArrays());
            }
            return reduced;
        }
        ArrayList rangesList = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalRange ranges = (InternalRange)aggregation;
            if (ranges.unmapped) continue;
            if (rangesList == null) {
                rangesList = new ArrayList(ranges.ranges.size());
                for (Bucket bucket : ranges.ranges) {
                    ArrayList<Bucket> sameRangeList = new ArrayList<Bucket>(aggregations.size());
                    sameRangeList.add(bucket);
                    rangesList.add(sameRangeList);
                }
                continue;
            }
            boolean bl = false;
            for (Bucket range : ranges.ranges) {
                void var7_13;
                ((List)rangesList.get((int)(++var7_13))).add(range);
            }
        }
        if (rangesList == null) {
            return aggregations.get(0);
        }
        InternalRange reduced = (InternalRange)aggregations.get(0);
        int i = 0;
        for (List list : rangesList) {
            reduced.ranges.set(i++, ((Bucket)list.get(0)).reduce(list, reduceContext.bigArrays()));
        }
        return reduced;
    }

    protected B createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
        return (B)new Bucket(key, from, to, docCount, aggregations, formatter);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> ranges = Lists.newArrayListWithCapacity(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readOptionalString();
            ranges.add(this.createBucket(key, in.readDouble(), in.readDouble(), in.readVLong(), InternalAggregations.readAggregations(in), this.formatter));
        }
        this.ranges = ranges;
        this.rangeMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.formatter, out);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.ranges.size());
        for (Bucket bucket : this.ranges) {
            out.writeOptionalString(bucket.key);
            out.writeDouble(bucket.from);
            out.writeDouble(bucket.to);
            out.writeVLong(bucket.docCount);
            bucket.aggregations.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.BUCKETS);
        } else {
            builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        }
        for (Bucket range : this.ranges) {
            range.toXContent(builder, params, this.formatter, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder.endObject();
    }

    public static class Factory<B extends Bucket, R extends InternalRange<B>> {
        public String type() {
            return TYPE.name();
        }

        public R create(String name, List<B> ranges, ValueFormatter formatter, boolean keyed, boolean unmapped) {
            return (R)new InternalRange<B>(name, ranges, formatter, keyed, unmapped);
        }

        public B createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            return (B)new Bucket(key, from, to, docCount, aggregations, formatter);
        }
    }

    public static class Bucket
    implements Range.Bucket {
        private double from = Double.NEGATIVE_INFINITY;
        private double to = Double.POSITIVE_INFINITY;
        private long docCount;
        InternalAggregations aggregations;
        private String key;
        private boolean explicitKey;

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            if (key != null) {
                this.key = key;
                this.explicitKey = true;
            } else {
                this.key = Bucket.key(from, to, formatter);
                this.explicitKey = false;
            }
            this.from = from;
            this.to = to;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(this.getKey());
        }

        @Override
        public Number getFrom() {
            return this.from;
        }

        @Override
        public Number getTo() {
            return this.to;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        Bucket reduce(List<Bucket> ranges, BigArrays bigArrays) {
            if (ranges.size() == 1) {
                Bucket bucket = ranges.get(0);
                bucket.aggregations.reduce(bigArrays);
                return bucket;
            }
            Bucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = Lists.newArrayListWithCapacity(ranges.size());
            for (Bucket range : ranges) {
                if (reduced == null) {
                    reduced = range;
                } else {
                    reduced.docCount += range.docCount;
                }
                aggregationsList.add(range.aggregations);
            }
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, bigArrays);
            return reduced;
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params, ValueFormatter formatter, boolean keyed) throws IOException {
            if (keyed) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
                if (this.explicitKey) {
                    builder.field(InternalAggregation.CommonFields.KEY, this.key);
                }
            }
            if (!Double.isInfinite(this.from)) {
                builder.field(InternalAggregation.CommonFields.FROM, this.from);
                if (formatter != null) {
                    builder.field(InternalAggregation.CommonFields.FROM_AS_STRING, formatter.format(this.from));
                }
            }
            if (!Double.isInfinite(this.to)) {
                builder.field(InternalAggregation.CommonFields.TO, this.to);
                if (formatter != null) {
                    builder.field(InternalAggregation.CommonFields.TO_AS_STRING, formatter.format(this.to));
                }
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        private static String key(double from, double to, ValueFormatter formatter) {
            StringBuilder sb = new StringBuilder();
            sb.append(Double.isInfinite(from) ? "*" : (formatter != null ? formatter.format(from) : Double.valueOf(from)));
            sb.append("-");
            sb.append(Double.isInfinite(to) ? "*" : (formatter != null ? formatter.format(to) : Double.valueOf(to)));
            return sb.toString();
        }
    }
}

