/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.format.DateTimeFormat;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestTable;

public class RestCountAction
extends AbstractCatAction {
    private DateTimeFormatter dateFormat = DateTimeFormat.forPattern("HH:mm:ss");

    @Inject
    protected RestCountAction(Settings settings, Client client, RestController restController) {
        super(settings, client);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/count", this);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/count/{index}", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/count\n");
        sb.append("/_cat/count/{index}\n");
    }

    @Override
    public void doRequest(final RestRequest request, final RestChannel channel) {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        CountRequest countRequest = new CountRequest(indices);
        countRequest.operationThreading(BroadcastOperationThreading.SINGLE_THREAD);
        String source = request.param("source");
        if (source != null) {
            countRequest.source(source);
        } else {
            QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
            if (querySourceBuilder != null) {
                countRequest.source(querySourceBuilder);
            }
        }
        this.client.count(countRequest, new ActionListener<CountResponse>(){

            @Override
            public void onResponse(CountResponse countResponse) {
                try {
                    channel.sendResponse(RestTable.buildResponse(RestCountAction.this.buildTable(request, countResponse), request, channel));
                }
                catch (Throwable t) {
                    this.onFailure(t);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, t));
                }
                catch (IOException e) {
                    RestCountAction.this.logger.error("Failed to send failure response", e, new Object[0]);
                }
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("epoch", "alias:t,time;desc:seconds since 1970-01-01 00:00:00, that the count was executed");
        table.addCell("timestamp", "alias:ts,hms;desc:time that the count was executed");
        table.addCell("count", "alias:dc,docs.count,docsCount;desc:the document count");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, CountResponse response) {
        Table table = this.getTableWithHeader(request);
        long time = System.currentTimeMillis();
        table.startRow();
        table.addCell(TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS));
        table.addCell(this.dateFormat.print(time));
        table.addCell(response.getCount());
        table.endRow();
        return table;
    }
}

