/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class TermsAggregatorFactory
extends ValueSourceAggregatorFactory {
    public static final String EXECUTION_HINT_VALUE_MAP = "map";
    public static final String EXECUTION_HINT_VALUE_ORDINALS = "ordinals";
    private final InternalOrder order;
    private final int requiredSize;
    private final int shardSize;
    private final long minDocCount;
    private final IncludeExclude includeExclude;
    private final String executionHint;

    public TermsAggregatorFactory(String name, ValuesSourceConfig valueSourceConfig, InternalOrder order, int requiredSize, int shardSize, long minDocCount, IncludeExclude includeExclude, String executionHint) {
        super(name, StringTerms.TYPE.name(), valueSourceConfig);
        this.order = order;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.minDocCount = minDocCount;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
        return new UnmappedTermsAggregator(this.name, this.order, this.requiredSize, this.minDocCount, aggregationContext, parent);
    }

    private static boolean hasParentBucketAggregator(Aggregator parent) {
        if (parent == null) {
            return false;
        }
        if (parent.bucketAggregationMode() == Aggregator.BucketAggregationMode.PER_BUCKET) {
            return true;
        }
        return TermsAggregatorFactory.hasParentBucketAggregator(parent.parent());
    }

    private boolean shouldUseOrdinals(Aggregator parent, ValuesSource valuesSource, AggregationContext context) {
        if (TermsAggregatorFactory.hasParentBucketAggregator(parent)) {
            return false;
        }
        long maxNumUniqueValues = valuesSource.metaData().maxAtomicUniqueValuesCount();
        if (maxNumUniqueValues == -1L) {
            return false;
        }
        int maxDoc = 0;
        for (AtomicReaderContext ctx : context.searchContext().searcher().getTopReaderContext().reader().leaves()) {
            maxDoc = Math.max(maxDoc, ctx.reader().maxDoc());
        }
        return maxNumUniqueValues <= (long)(maxDoc >>> 4);
    }

    protected Aggregator create(ValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
        long estimatedBucketCount = valuesSource.metaData().maxAtomicUniqueValuesCount();
        if (estimatedBucketCount < 0L) {
            estimatedBucketCount = 50L;
        }
        estimatedBucketCount = Math.min(estimatedBucketCount, 512L);
        if (valuesSource instanceof BytesValuesSource) {
            if (this.executionHint != null && !this.executionHint.equals(EXECUTION_HINT_VALUE_MAP) && !this.executionHint.equals(EXECUTION_HINT_VALUE_ORDINALS)) {
                throw new ElasticsearchIllegalArgumentException("execution_hint can only be 'map' or 'ordinals', not " + this.executionHint);
            }
            String execution = this.executionHint;
            if (!(valuesSource instanceof BytesValuesSource.WithOrdinals)) {
                execution = EXECUTION_HINT_VALUE_MAP;
            } else if (this.includeExclude != null) {
                execution = EXECUTION_HINT_VALUE_MAP;
            }
            if (execution == null) {
                execution = valuesSource instanceof BytesValuesSource.WithOrdinals && this.shouldUseOrdinals(parent, valuesSource, aggregationContext) ? EXECUTION_HINT_VALUE_ORDINALS : EXECUTION_HINT_VALUE_MAP;
            }
            assert (execution != null);
            if (execution.equals(EXECUTION_HINT_VALUE_ORDINALS)) {
                assert (this.includeExclude == null);
                return new StringTermsAggregator.WithOrdinals(this.name, this.factories, (BytesValuesSource.WithOrdinals)valuesSource, estimatedBucketCount, this.order, this.requiredSize, this.shardSize, this.minDocCount, aggregationContext, parent);
            }
            return new StringTermsAggregator(this.name, this.factories, valuesSource, estimatedBucketCount, this.order, this.requiredSize, this.shardSize, this.minDocCount, this.includeExclude, aggregationContext, parent);
        }
        if (this.includeExclude != null) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support the include/exclude " + "settings as it can only be applied to string values");
        }
        if (valuesSource instanceof NumericValuesSource) {
            if (((NumericValuesSource)valuesSource).isFloatingPoint()) {
                return new DoubleTermsAggregator(this.name, this.factories, (NumericValuesSource)valuesSource, estimatedBucketCount, this.order, this.requiredSize, this.shardSize, this.minDocCount, aggregationContext, parent);
            }
            return new LongTermsAggregator(this.name, this.factories, (NumericValuesSource)valuesSource, estimatedBucketCount, this.order, this.requiredSize, this.shardSize, this.minDocCount, aggregationContext, parent);
        }
        throw new AggregationExecutionException("terms aggregation cannot be applied to field [" + this.valuesSourceConfig.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }
}

