/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.XContentStructure;

public class IndicesQueryParser
implements QueryParser {
    public static final String NAME = "indices";
    @Nullable
    private final ClusterService clusterService;

    @Inject
    public IndicesQueryParser(@Nullable ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query noMatchQuery = null;
        boolean queryFound = false;
        boolean indicesFound = false;
        boolean currentIndexMatchesIndices = false;
        String queryName = null;
        String currentFieldName = null;
        XContentStructure.InnerQuery innerQuery = null;
        XContentStructure.InnerQuery innerNoMatchQuery = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    innerQuery = new XContentStructure.InnerQuery(parseContext, null);
                    queryFound = true;
                    continue;
                }
                if ("no_match_query".equals(currentFieldName)) {
                    innerNoMatchQuery = new XContentStructure.InnerQuery(parseContext, null);
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[indices] query does not support [" + currentFieldName + "]");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (NAME.equals(currentFieldName)) {
                    if (indicesFound) {
                        throw new QueryParsingException(parseContext.index(), "[indices] indices or index already specified");
                    }
                    indicesFound = true;
                    ArrayList<String> indices = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        String value = parser.textOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "[indices] no value specified for 'indices' entry");
                        }
                        indices.add(value);
                    }
                    currentIndexMatchesIndices = this.matchesIndices(parseContext.index().name(), indices.toArray(new String[indices.size()]));
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[indices] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("index".equals(currentFieldName)) {
                if (indicesFound) {
                    throw new QueryParsingException(parseContext.index(), "[indices] indices or index already specified");
                }
                indicesFound = true;
                currentIndexMatchesIndices = this.matchesIndices(parseContext.index().name(), parser.text());
                continue;
            }
            if ("no_match_query".equals(currentFieldName)) {
                String type = parser.text();
                if ("all".equals(type)) {
                    noMatchQuery = Queries.newMatchAllQuery();
                    continue;
                }
                if (!"none".equals(type)) continue;
                noMatchQuery = Queries.newMatchNoDocsQuery();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[indices] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[indices] requires 'query' element");
        }
        if (!indicesFound) {
            throw new QueryParsingException(parseContext.index(), "[indices] requires 'indices' or 'index' element");
        }
        Query chosenQuery = currentIndexMatchesIndices ? innerQuery.asQuery(new String[0]) : (noMatchQuery != null ? noMatchQuery : (innerNoMatchQuery == null ? Queries.newMatchAllQuery() : innerNoMatchQuery.asQuery(new String[0])));
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, chosenQuery);
        }
        return chosenQuery;
    }

    protected boolean matchesIndices(String currentIndex, String ... indices) {
        String[] concreteIndices;
        for (String index : concreteIndices = this.clusterService.state().metaData().concreteIndicesIgnoreMissing(indices)) {
            if (!Regex.simpleMatch(index, currentIndex)) continue;
            return true;
        }
        return false;
    }
}

