/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class DoubleTermsAggregator
extends BucketsAggregator {
    private final InternalOrder order;
    private final int requiredSize;
    private final int shardSize;
    private final long minDocCount;
    private final NumericValuesSource valuesSource;
    private final LongHash bucketOrds;
    private DoubleValues values;

    public DoubleTermsAggregator(String name, AggregatorFactories factories, NumericValuesSource valuesSource, long estimatedBucketCount, InternalOrder order, int requiredSize, int shardSize, long minDocCount, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, estimatedBucketCount, aggregationContext, parent);
        this.valuesSource = valuesSource;
        this.order = InternalOrder.validate(order, this);
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.minDocCount = minDocCount;
        this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int valuesCount = this.values.setDocument(doc);
        for (int i = 0; i < valuesCount; ++i) {
            double val = this.values.nextValue();
            long bits = Double.doubleToRawLongBits(val);
            long bucketOrdinal = this.bucketOrds.add(bits);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
            }
            this.collectBucket(doc, bucketOrdinal);
        }
    }

    @Override
    public DoubleTerms buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        if (this.minDocCount == 0L && (this.order != InternalOrder.COUNT_DESC || this.bucketOrds.size() < (long)this.requiredSize)) {
            for (AtomicReaderContext ctx : this.context.searchContext().searcher().getTopReaderContext().leaves()) {
                this.context.setNextReader(ctx);
                DoubleValues values = this.valuesSource.doubleValues();
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    int valueCount = values.setDocument(docId);
                    for (int i = 0; i < valueCount; ++i) {
                        this.bucketOrds.add(Double.doubleToLongBits(values.nextValue()));
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        DoubleTerms.Bucket spare = null;
        for (long i = 0L; i < this.bucketOrds.capacity(); ++i) {
            long ord = this.bucketOrds.id(i);
            if (ord < 0L) continue;
            if (spare == null) {
                spare = new DoubleTerms.Bucket(0.0, 0L, null);
            }
            spare.term = Double.longBitsToDouble(this.bucketOrds.key(i));
            spare.docCount = this.bucketDocCount(ord);
            spare.bucketOrd = ord;
            spare = (DoubleTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            DoubleTerms.Bucket bucket = (DoubleTerms.Bucket)ordered.pop();
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new DoubleTerms(this.name, this.order, this.valuesSource.formatter(), this.requiredSize, this.minDocCount, Arrays.asList(list));
    }

    @Override
    public DoubleTerms buildEmptyAggregation() {
        return new DoubleTerms(this.name, this.order, this.valuesSource.formatter(), this.requiredSize, this.minDocCount, Collections.<InternalTerms.Bucket>emptyList());
    }

    @Override
    public void doRelease() {
        Releasables.release(this.bucketOrds);
    }
}

