/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.transport.TransportRequest;

public class ShardSearchRequest
extends TransportRequest {
    private String index;
    private int shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private String[] filteringAliases;
    private BytesReference source;
    private BytesReference extraSource;
    private BytesReference templateSource;
    private String templateName;
    private Map<String, String> templateParams;
    private long nowInMillis;

    public ShardSearchRequest() {
    }

    public ShardSearchRequest(SearchRequest searchRequest, ShardRouting shardRouting, int numberOfShards) {
        super(searchRequest);
        this.index = shardRouting.index();
        this.shardId = shardRouting.id();
        this.numberOfShards = numberOfShards;
        this.searchType = searchRequest.searchType();
        this.source = searchRequest.source();
        this.extraSource = searchRequest.extraSource();
        this.templateSource = searchRequest.templateSource();
        this.templateName = searchRequest.templateName();
        this.templateParams = searchRequest.templateParams();
        this.scroll = searchRequest.scroll();
        this.types = searchRequest.types();
    }

    public ShardSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchType searchType) {
        this(shardRouting.index(), shardRouting.id(), numberOfShards, searchType);
    }

    public ShardSearchRequest(String index, int shardId, int numberOfShards, SearchType searchType) {
        this.index = index;
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
    }

    public String index() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference extraSource() {
        return this.extraSource;
    }

    public ShardSearchRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public ShardSearchRequest extraSource(BytesReference extraSource) {
        this.extraSource = extraSource;
        return this;
    }

    public BytesReference templateSource() {
        return this.templateSource;
    }

    public String templateName() {
        return this.templateName;
    }

    public Map<String, String> templateParams() {
        return this.templateParams;
    }

    public ShardSearchRequest nowInMillis(long nowInMillis) {
        this.nowInMillis = nowInMillis;
        return this;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public ShardSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public ShardSearchRequest filteringAliases(String[] filteringAliases) {
        this.filteringAliases = filteringAliases;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public ShardSearchRequest types(String[] types) {
        this.types = types;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.source = in.readBytesReference();
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.filteringAliases = in.readStringArray();
        this.nowInMillis = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.templateSource = in.readBytesReference();
            this.templateName = in.readOptionalString();
            if (in.readBoolean()) {
                this.templateParams = (Map)in.readGenericValue();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeByte(this.searchType.id());
        out.writeVInt(this.numberOfShards);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        out.writeStringArrayNullable(this.filteringAliases);
        out.writeVLong(this.nowInMillis);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeBytesReference(this.templateSource);
            out.writeOptionalString(this.templateName);
            boolean existTemplateParams = this.templateParams != null;
            out.writeBoolean(existTemplateParams);
            if (existTemplateParams) {
                out.writeGenericValue(this.templateParams);
            }
        }
    }
}

