/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.search.suggest.fst.ExternalRefSorter;
import org.apache.lucene.search.suggest.fst.FSTCompletion;
import org.apache.lucene.search.suggest.fst.FSTCompletionBuilder;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NoOutputs;
import org.apache.lucene.util.fst.Outputs;

public class FSTCompletionLookup
extends Lookup {
    private static int INVALID_BUCKETS_COUNT = -1;
    private static final int sharedTailLength = 5;
    private int buckets;
    private boolean exactMatchFirst;
    private FSTCompletion higherWeightsCompletion;
    private FSTCompletion normalCompletion;
    private long count = 0L;

    public FSTCompletionLookup() {
        this(10, true);
    }

    public FSTCompletionLookup(int buckets, boolean exactMatchFirst) {
        this.buckets = buckets;
        this.exactMatchFirst = exactMatchFirst;
    }

    public FSTCompletionLookup(FSTCompletion completion, boolean exactMatchFirst) {
        this(INVALID_BUCKETS_COUNT, exactMatchFirst);
        this.normalCompletion = new FSTCompletion(completion.getFST(), false, exactMatchFirst);
        this.higherWeightsCompletion = new FSTCompletion(completion.getFST(), true, exactMatchFirst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iterator) throws IOException {
        File tempSorted;
        File tempInput;
        block9: {
            ExternalRefSorter sorter;
            Sort.ByteSequencesReader reader;
            Sort.ByteSequencesWriter writer;
            block8: {
                if (iterator.hasPayloads()) {
                    throw new IllegalArgumentException("this suggester doesn't support payloads");
                }
                tempInput = File.createTempFile(FSTCompletionLookup.class.getSimpleName(), ".input", Sort.defaultTempDir());
                tempSorted = File.createTempFile(FSTCompletionLookup.class.getSimpleName(), ".sorted", Sort.defaultTempDir());
                writer = new Sort.ByteSequencesWriter(tempInput);
                reader = null;
                sorter = null;
                boolean success = false;
                this.count = 0L;
                try {
                    BytesRef spare;
                    byte[] buffer = new byte[]{};
                    ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
                    while ((spare = iterator.next()) != null) {
                        if (spare.length + 4 >= buffer.length) {
                            buffer = ArrayUtil.grow((byte[])buffer, (int)(spare.length + 4));
                        }
                        output.reset(buffer);
                        output.writeInt(FSTCompletionLookup.encodeWeight(iterator.weight()));
                        output.writeBytes(spare.bytes, spare.offset, spare.length);
                        writer.write(buffer, 0, output.getPosition());
                    }
                    writer.close();
                    Sort.SortInfo info = new Sort().sort(tempInput, tempSorted);
                    tempInput.delete();
                    sorter = new ExternalRefSorter(new Sort());
                    FSTCompletionBuilder builder = new FSTCompletionBuilder(this.buckets, sorter, 5);
                    int inputLines = info.lines;
                    reader = new Sort.ByteSequencesReader(tempSorted);
                    long line = 0L;
                    int previousBucket = 0;
                    int previousScore = 0;
                    ByteArrayDataInput input = new ByteArrayDataInput();
                    BytesRef tmp1 = new BytesRef();
                    BytesRef tmp2 = new BytesRef();
                    while (reader.read(tmp1)) {
                        input.reset(tmp1.bytes);
                        int currentScore = input.readInt();
                        int bucket = line > 0L && currentScore == previousScore ? previousBucket : (int)(line * (long)this.buckets / (long)inputLines);
                        previousScore = currentScore;
                        previousBucket = bucket;
                        tmp2.bytes = tmp1.bytes;
                        tmp2.offset = input.getPosition();
                        tmp2.length = tmp1.length - input.getPosition();
                        builder.add(tmp2, bucket);
                        ++line;
                        ++this.count;
                    }
                    this.higherWeightsCompletion = builder.build();
                    this.normalCompletion = new FSTCompletion(this.higherWeightsCompletion.getFST(), false, this.exactMatchFirst);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader, writer, sorter});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer, sorter});
                    }
                    tempInput.delete();
                    tempSorted.delete();
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader, writer, sorter});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer, sorter});
        }
        tempInput.delete();
        tempSorted.delete();
    }

    private static int encodeWeight(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return (int)value;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean higherWeightsFirst, int num) {
        List<FSTCompletion.Completion> completions = higherWeightsFirst ? this.higherWeightsCompletion.lookup(key, num) : this.normalCompletion.lookup(key, num);
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(completions.size());
        CharsRef spare = new CharsRef();
        for (FSTCompletion.Completion c : completions) {
            spare.grow(c.utf8.length);
            UnicodeUtil.UTF8toUTF16((BytesRef)c.utf8, (CharsRef)spare);
            results.add(new Lookup.LookupResult(spare.toString(), c.bucket));
        }
        return results;
    }

    public Object get(CharSequence key) {
        int bucket = this.normalCompletion.getBucket(key);
        return bucket == -1 ? null : Long.valueOf(bucket);
    }

    @Override
    public synchronized boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.normalCompletion == null || this.normalCompletion.getFST() == null) {
            return false;
        }
        this.normalCompletion.getFST().save(output);
        return true;
    }

    @Override
    public synchronized boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.higherWeightsCompletion = new FSTCompletion((FST<Object>)new FST(input, (Outputs)NoOutputs.getSingleton()));
        this.normalCompletion = new FSTCompletion(this.higherWeightsCompletion.getFST(), false, this.exactMatchFirst);
        return true;
    }

    @Override
    public long sizeInBytes() {
        return RamUsageEstimator.sizeOf((Object)this);
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

