/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum ThreadingModel {
    NONE(0),
    OPERATION(1),
    LISTENER(2),
    OPERATION_LISTENER(3);

    private byte id;

    private ThreadingModel(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public boolean threadedOperation() {
        return this == OPERATION || this == OPERATION_LISTENER;
    }

    public boolean threadedListener() {
        return this == LISTENER || this == OPERATION_LISTENER;
    }

    public ThreadingModel addListener() {
        if (this == NONE) {
            return LISTENER;
        }
        if (this == OPERATION) {
            return OPERATION_LISTENER;
        }
        return this;
    }

    public ThreadingModel removeListener() {
        if (this == LISTENER) {
            return NONE;
        }
        if (this == OPERATION_LISTENER) {
            return OPERATION;
        }
        return this;
    }

    public ThreadingModel addOperation() {
        if (this == NONE) {
            return OPERATION;
        }
        if (this == LISTENER) {
            return OPERATION_LISTENER;
        }
        return this;
    }

    public ThreadingModel removeOperation() {
        if (this == OPERATION) {
            return NONE;
        }
        if (this == OPERATION_LISTENER) {
            return LISTENER;
        }
        return this;
    }

    public static ThreadingModel fromId(byte id) {
        if (id == 0) {
            return NONE;
        }
        if (id == 1) {
            return OPERATION;
        }
        if (id == 2) {
            return LISTENER;
        }
        if (id == 3) {
            return OPERATION_LISTENER;
        }
        throw new ElasticsearchIllegalArgumentException("No threading model for [" + id + "]");
    }
}

