/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class BinaryFieldMapper
extends AbstractFieldMapper<BytesReference> {
    public static final String CONTENT_TYPE = "binary";
    private Boolean compress;
    private long compressThreshold;

    protected BinaryFieldMapper(FieldMapper.Names names, FieldType fieldType, Boolean compress, long compressThreshold, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, 1.0f, fieldType, null, null, null, postingsProvider, docValuesProvider, null, null, null, null, multiFields, copyTo);
        this.compress = compress;
        this.compressThreshold = compressThreshold;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return null;
    }

    @Override
    public Object valueForSearch(Object value) {
        return this.value(value);
    }

    @Override
    public BytesReference value(Object value) {
        BytesReference bytes;
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            bytes = new BytesArray((BytesRef)value);
        } else if (value instanceof BytesReference) {
            bytes = (BytesReference)value;
        } else if (value instanceof byte[]) {
            bytes = new BytesArray((byte[])value);
        } else {
            try {
                bytes = new BytesArray(Base64.decode(value.toString()));
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to convert bytes", e);
            }
        }
        try {
            return CompressorFactory.uncompressIfNeeded(bytes);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", e);
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.fieldType().stored()) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.compress != null && this.compress.booleanValue() && !CompressorFactory.isCompressed(value, 0, value.length) && (this.compressThreshold == -1L || (long)value.length > this.compressThreshold)) {
            BytesStreamOutput bStream = new BytesStreamOutput();
            CompressedStreamOutput stream = CompressorFactory.defaultCompressor().streamOutput(bStream);
            ((StreamOutput)stream).writeBytes(value, 0, value.length);
            ((StreamOutput)stream).close();
            value = bStream.bytes().toBytes();
        }
        fields.add(new Field(this.names.indexName(), value, this.fieldType));
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        if (includeDefaults || !this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        } else if (includeDefaults) {
            builder.field("compress", false);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        } else if (includeDefaults) {
            builder.field("compress_threshold", -1);
        }
        if (includeDefaults || this.fieldType.stored() != this.defaultFieldType().stored()) {
            builder.field("store", this.fieldType.stored());
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!(mergeWith instanceof BinaryFieldMapper)) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof AbstractFieldMapper) {
                mergedType = ((AbstractFieldMapper)mergeWith).contentType();
            }
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
            return;
        }
        BinaryFieldMapper sourceMergeWith = (BinaryFieldMapper)mergeWith;
        if (this.fieldType().stored() != sourceMergeWith.fieldType().stored()) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store values");
        }
        if (!this.names().equals(sourceMergeWith.names())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_name");
        }
        if (!mergeContext.mergeFlags().simulate()) {
            if (sourceMergeWith.compress != null) {
                this.compress = sourceMergeWith.compress;
            }
            if (sourceMergeWith.compressThreshold != -1L) {
                this.compressThreshold = sourceMergeWith.compressThreshold;
            }
        }
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.binaryField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("compress") && fieldNode != null) {
                    builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("compress_threshold") || fieldNode == null) continue;
                if (fieldNode instanceof Number) {
                    builder.compressThreshold(((Number)fieldNode).longValue());
                    builder.compress(true);
                    continue;
                }
                builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
                builder.compress(true);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, BinaryFieldMapper> {
        private Boolean compress = null;
        private long compressThreshold = -1L;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            return new BinaryFieldMapper(this.buildNames(context), this.fieldType, this.compress, this.compressThreshold, this.postingsProvider, this.docValuesProvider, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.freeze();
        }
    }
}

