/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;

public abstract class AbstractMergePolicyProvider<MP extends MergePolicy>
extends AbstractIndexShardComponent
implements MergePolicyProvider<MP> {
    public static final String INDEX_COMPOUND_FORMAT = "index.compound_format";
    protected volatile double noCFSRatio;

    protected AbstractMergePolicyProvider(Store store) {
        super(store.shardId(), store.indexSettings());
        this.noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(this.indexSettings.get(INDEX_COMPOUND_FORMAT, Boolean.toString(store.suggestUseCompoundFile())));
    }

    public static double parseNoCFSRatio(String noCFSRatio) {
        if ((noCFSRatio = noCFSRatio.trim()).equalsIgnoreCase("true")) {
            return 1.0;
        }
        if (noCFSRatio.equalsIgnoreCase("false")) {
            return 0.0;
        }
        try {
            double value = Double.parseDouble(noCFSRatio);
            if (value < 0.0 || value > 1.0) {
                throw new ElasticsearchIllegalArgumentException("NoCFSRatio must be in the interval [0..1] but was: [" + value + "]");
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchIllegalArgumentException("Expected a boolean or a value in the interval [0..1] but was: [" + noCFSRatio + "]", ex);
        }
    }

    public static String formatNoCFSRatio(double ratio) {
        if (ratio == 1.0) {
            return Boolean.TRUE.toString();
        }
        if (ratio == 0.0) {
            return Boolean.FALSE.toString();
        }
        return Double.toString(ratio);
    }
}

