/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public abstract class ValuesSourceAggregationBuilder<B extends ValuesSourceAggregationBuilder<B>>
extends AggregationBuilder<B> {
    private String field;
    private String script;
    private String lang;
    private Map<String, Object> params;

    protected ValuesSourceAggregationBuilder(String name, String type) {
        super(name, type);
    }

    public B field(String field) {
        this.field = field;
        return (B)this;
    }

    public B script(String script) {
        this.script = script;
        return (B)this;
    }

    public B lang(String lang) {
        this.lang = lang;
        return (B)this;
    }

    public B param(String name, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value);
        return (B)this;
    }

    public B params(Map<String, Object> params) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.putAll(params);
        return (B)this;
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null) {
            builder.field("params").map(this.params);
        }
        this.doInternalXContent(builder, params);
        return builder.endObject();
    }

    protected abstract XContentBuilder doInternalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

